package org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations

import amf.core.client.scala.model.document.{BaseUnit, DeclaresModel}
import amf.core.client.scala.model.domain.{DomainElement, NamedDomainElement}
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.GRPCDeclarationsScopeUtils.{getDeclarationScope, splitScope}

import scala.annotation.tailrec

class DeclarationProvider(private val baseUnit: BaseUnit) {

  def getDeclaredFor(currentScope: String): Seq[String] =
    declaredFullNames.map(cleanScope(_, currentScope))

  private val declared: Seq[DomainElement] =
    getDeclarations(baseUnit) ++ baseUnit.references.flatMap(getDeclarations)

  private def getDeclarations(baseUnit: BaseUnit): Seq[DomainElement] =
    baseUnit match {
      case declarable: DeclaresModel => declarable.declares
      case _ => Seq.empty
    }

  private val declaredFullNames: Seq[String] =
    declared
      .flatMap(getDeclarationScope)
      .flatMap(_.option())

  private def cleanScope(fullScope: String, currentScope: String): String = {
    @tailrec
    def innerClean(finalParts: List[String], currentParts: List[String]): String =
      if (isSameScope(finalParts, currentParts)) {
        innerClean(finalParts.tail, currentParts.tail)
      } else {
        makeStringFromList(finalParts)
      }

    val finalParts = splitScope(fullScope)
    val currentParts = splitScope(currentScope)

    Some(List.apply(innerClean(finalParts.dropRight(1), currentParts), finalParts.last))
      .map(s => makeStringFromList(s))
      .get
  }

  private def isSameScope(full: List[String], current: List[String]): Boolean =
    full.nonEmpty && current.nonEmpty && full.head.equals(current.head)

  private def makeStringFromList(list: List[String]): String =
    list
      .filter(_.nonEmpty)
      .mkString(GRPCDeclarationsScopeUtils.scopeSeparator)
}
