package org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations

import amf.apicontract.client.scala.model.domain.api.WebApi
import amf.core.client.scala.model.StrField
import amf.core.client.scala.model.domain.AmfElement
import amf.shapes.client.scala.model.domain.{NodeShape, ScalarShape}
import org.mulesoft.als.suggestions.plugins.antlr.CompletionPluginParams

object GRPCDeclarationsScopeUtils {
  val scopeSeparator: String = "."

  def getScope(params: CompletionPluginParams): Option[StrField] =
    params.stack.branch
      .view
      .flatMap(getDeclarationScope)
      .headOption

  def getDeclarationScope(element: AmfElement): Option[StrField] =
    element match {
      case element: NodeShape => Some(element.name)
      case scalar: ScalarShape => Some(scalar.name)
      case webApi: WebApi => Some(webApi.name)
      case _ => None
    }

  def splitScope(scope: String): List[String] =
    Some(scope)
      .filter(s => !s.isBlank)
      .map(_.stripPrefix(GRPCDeclarationsScopeUtils.scopeSeparator))
      .map(_.split(GRPCDeclarationsScopeUtils.scopeSeparator.toCharArray))
      .map(_.toList)
      .getOrElse(List.empty)
}
