package org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets

import amf.core.client.scala.model.StrField
import amf.grpc.internal.spec.parser.syntax.TokenTypes.{ENUM_BODY, ENUM_DEF}
import org.mulesoft.als.suggestions.antlr.grpc.AstNodeKnowledge.isInside
import org.mulesoft.als.suggestions.antlr.grpc.GRPCGrammarInfo
import org.mulesoft.als.suggestions.plugins.antlr.CompletionPluginParams
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.DeclarationProvider
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.GRPCDeclarationsScopeUtils.getScope
import org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets.ReusableSnippets.{optionalStructureSnippet, reservedStructureSnippet}
import org.mulesoft.als.suggestions.plugins.antlr.snippets.{SnippetPlugin, SnippetStructure}

object EnumBodySnippets extends SnippetPlugin {
  override def getAll(params: CompletionPluginParams): Seq[SnippetStructure] =
    if (!isInside(params.stack, Seq(Left(ENUM_DEF), Left(ENUM_BODY)))) Seq.empty
    else
      getScope(params)
        .map(scope => getSnippetStructures(params.declarations, scope))
        .getOrElse(Seq.empty)

  private def getSnippetStructures(declarationProvider: DeclarationProvider, scope: StrField): Seq[SnippetStructure] = {
    Seq(
      SnippetStructure(
        "element",
        plainElement
      ),
      optionalStructureSnippet(declarationProvider, scope),
      reservedStructureSnippet
    )
  }

  private def plainElement: String = s"$${1:NAME} = $${2:VALUE};\n$$0"

  // TODO: Add logic to add option allow_alias
  private def addOptionAllow_alias(): SnippetStructure =
    SnippetStructure(
      "allow alias",
      s"option allow_alias = $${1:|${GRPCGrammarInfo.booleanTypes}|};"
    )

//  /**
//   * In proto3, the first value defined in an enum definition must have the value zero and should have the name ENUM_TYPE_NAME_UNSPECIFIED or ENUM_TYPE_NAME_UNKNOWN. This is because:
//   *
//   * There must be a zero value, so that we can use 0 as a numeric default value.
//   * The zero value needs to be the first element, for compatibility with the proto2 semantics where the first enum value is the default unless a different value is explicitly specified.
//   */
//  private def plainFirstElement: String = s"$${1:NAME}_UNSPECIFIED = 0;\n$$0"
}