package org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets

import amf.core.client.scala.model.StrField
import amf.grpc.internal.spec.parser.syntax.TokenTypes.{MESSAGE_BODY, MESSAGE_DEF}
import org.mulesoft.als.suggestions.antlr.grpc.AstNodeKnowledge.isInside
import org.mulesoft.als.suggestions.antlr.grpc.GRPCGrammarInfo
import org.mulesoft.als.suggestions.plugins.antlr.CompletionPluginParams
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.DeclarationProvider
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.GRPCDeclarationsScopeUtils.getScope
import org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets.ReusableSnippets._
import org.mulesoft.als.suggestions.plugins.antlr.snippets.{SnippetPlugin, SnippetStructure}

object MessageBodySnippets extends SnippetPlugin {

  override def getAll(params: CompletionPluginParams): Seq[SnippetStructure] =
    if (!isInside(params.stack, Seq(Left(MESSAGE_DEF), Left(MESSAGE_BODY)))) Seq.empty
    else
      getScope(params)
        .map(scope => getSnippetStructures(params.declarations, scope))
        .getOrElse(Seq.empty)

  private def getSnippetStructures(declarationProvider: DeclarationProvider, scope: StrField): Seq[SnippetStructure] = {
    Seq(
      SnippetStructure(
        "field",
        plainFieldBody(declarationProvider, scope)
      ),
      SnippetStructure(
        "repeated",
        s"repeated ${plainFieldBody(declarationProvider, scope)}"
      ),
      optionalStructureSnippet(declarationProvider, scope),
      SnippetStructure(
        "oneof",
        s"oneof $${1:NAME} {\n  $$2\n}\n$$0"
      ),
      SnippetStructure(
        "map",
        s"map<$${1|${GRPCGrammarInfo.mapKeyTypes.mkString(",")}|},$${2|${allTypes(declarationProvider, scope).mkString(",")}|}> $${3:NAME} = $${4:VALUE};\n$$0"
      ),
      reservedStructureSnippet,
      enumStructureSnippet,
      messageStructureSnippet
    )
  }
}