package org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets

import amf.core.client.scala.model.StrField
import amf.grpc.internal.spec.parser.syntax.TokenTypes.ONE_OF
import org.mulesoft.als.suggestions.antlr.grpc.AstNodeKnowledge.isInside
import org.mulesoft.als.suggestions.antlr.grpc.GRPCGrammarInfo.{LC, RC}
import org.mulesoft.als.suggestions.plugins.antlr.CompletionPluginParams
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.DeclarationProvider
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.GRPCDeclarationsScopeUtils.getScope
import org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets.ReusableSnippets._
import org.mulesoft.als.suggestions.plugins.antlr.snippets.{SnippetPlugin, SnippetStructure}

object OneofBodySnippets extends SnippetPlugin {

  override def getAll(params: CompletionPluginParams): Seq[SnippetStructure] =
    if (!isInside(params.stack, Seq(Left(ONE_OF), Right(LC,RC)))) Seq.empty
    else
      getScope(params)
        .map(scope => getSnippetStructures(params.declarations, scope))
        .getOrElse(Seq.empty)

  private def getSnippetStructures(declarationProvider: DeclarationProvider, scope: StrField): Seq[SnippetStructure] = {
    Seq(
      SnippetStructure(
        "field",
        plainFieldBody(declarationProvider, scope)
      ),
      optionalStructureSnippet(declarationProvider, scope),
      reservedStructureSnippet,
      enumStructureSnippet,
      messageStructureSnippet
    )
  }
}