package org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets

import amf.core.client.scala.model.StrField
import org.mulesoft.als.suggestions.antlr.grpc.GRPCGrammarInfo
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.DeclarationProvider
import org.mulesoft.als.suggestions.plugins.antlr.snippets.SnippetStructure

object ReusableSnippets {
  val messageStructureSnippet: SnippetStructure = SnippetStructure("message",
    """message ${1:NAME} {
      |  $2
      |}$0""".stripMargin, Some("Defines a message type."))


  val enumStructureSnippet: SnippetStructure =
    SnippetStructure("enum",
      """enum ${1:NAME} {
        |  $2
        |}$0""".stripMargin, Some("Defines an enum type."))

  val reservedStructureSnippet: SnippetStructure =
    SnippetStructure(
      "reserved",
      s"reserved $${1:RESERVED_VALUES};\n$$0"
    )

  def optionalStructureSnippet(declarationProvider: DeclarationProvider, scope: StrField): SnippetStructure =
    SnippetStructure(
      "optional",
      s"optional ${plainFieldBody(declarationProvider, scope)}"
    )

  def plainFieldBody(declarationProvider: DeclarationProvider, scope: StrField): String =
    s"$${1|${allTypes(declarationProvider, scope).mkString(",")}|} $${2:NAME} = $${3:VALUE};\n$$0"

  def allTypes(declarationProvider: DeclarationProvider, scope: StrField): Seq[String] =
    GRPCGrammarInfo.scalarTypes ++ declarationProvider.getDeclaredFor(scope.value())
}
