package org.mulesoft.als.suggestions.plugins.antlr.snippets

import org.mulesoft.lsp.feature.completion.{CompletionItem, CompletionItemKind, InsertTextFormat}

case class SnippetStructure (label: String, content: String, description: Option[String] = None) {
  def toCompletionItem: CompletionItem = CompletionItem(s"new $label",
    kind = Some(CompletionItemKind.Snippet),
    detail = description,
    sortText = Some(s"00$label"),
    insertText = Some(content),
    insertTextFormat = Some(InsertTextFormat.Snippet)
  )
}