package org.mulesoft.als.suggestions.plugins.jsonschema

import amf.core.client.scala.model.domain.Shape
import amf.core.client.scala.model.domain.extensions.PropertyShape
import amf.core.internal.parser.domain.FieldEntry
import org.mulesoft.als.suggestions.RawSuggestion
import org.mulesoft.als.suggestions.aml.AmlCompletionRequest
import org.mulesoft.als.suggestions.interfaces.AMLCompletionPlugin
import org.mulesoft.amfintegration.AmfImplicits.AmfAnnotationsImp
import org.mulesoft.amfintegration.amfconfiguration.executioncontext.Implicits.global

import scala.concurrent.Future

trait JsonSchemaBaseCompletionPlugin extends AMLCompletionPlugin {
  def findDefinitionShape(fieldEntry: FieldEntry): Option[Shape] =
    Some(fieldEntry)
      .flatMap(field => field.value.annotations.sourceSchemaDef())
      .map(schema => schema.definition)
      .collect { case shape: PropertyShape => shape }
      .map(shape => shape.range)


  private def filterDuplicates(suggestions: Seq[RawSuggestion]): Seq[RawSuggestion] =
    suggestions
      .groupBy(newTextHash)
      .flatMap(_._2.headOption)
      .toSeq

  private def newTextHash(suggestion: RawSuggestion): String = suggestion.newText.concat(suggestion.children.map(newTextHash).mkString("*"))

  def innerResolve(request: AmlCompletionRequest): Future[Seq[RawSuggestion]]

  override final def resolve(request: AmlCompletionRequest): Future[Seq[RawSuggestion]] = innerResolve(request).map(filterDuplicates)
}
