/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.core.AMFCompiler$;
import amf.core.Root;
import amf.core.exception.CyclicReferenceException;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.EncodesModel;
import amf.core.model.document.ExternalFragment;
import amf.core.model.document.ExternalFragment$;
import amf.core.model.domain.ExternalDomainElement;
import amf.core.model.domain.ExternalDomainElement$;
import amf.core.parser.ParsedDocument;
import amf.core.parser.ParsedReference;
import amf.core.parser.ParsedReference$;
import amf.core.parser.ParserContext;
import amf.core.parser.ParserContext$;
import amf.core.parser.Reference;
import amf.core.parser.ReferenceHandler;
import amf.core.parser.ReferenceKind;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.plugins.AMFFeaturePlugin;
import amf.core.plugins.AMFSyntaxPlugin;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Cache;
import amf.core.remote.Content;
import amf.core.remote.Context;
import amf.core.remote.Context$;
import amf.core.remote.FileMediaType$;
import amf.core.remote.FileNotFound;
import amf.core.remote.Platform;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext$Implicits$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001\u001d\u00111\"Q'G\u0007>l\u0007/\u001b7fe*\u00111\u0001B\u0001\u0005G>\u0014XMC\u0001\u0006\u0003\r\tWNZ\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u00051!/Y<Ve2,\u0012!\u0005\t\u0003%eq!aE\f\u0011\u0005QQQ\"A\u000b\u000b\u0005Y1\u0011A\u0002\u001fs_>$h(\u0003\u0002\u0019\u0015\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tA\"\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0012\u0003\u001d\u0011\u0018m^+sY\u0002B\u0001b\b\u0001\u0003\u0006\u0004%\t\u0001I\u0001\u0007e\u0016lw\u000e^3\u0016\u0003\u0005\u0002\"A\t\u0013\u000e\u0003\rR!a\b\u0002\n\u0005\u0015\u001a#\u0001\u0003)mCR4wN]7\t\u0011\u001d\u0002!\u0011!Q\u0001\n\u0005\nqA]3n_R,\u0007\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0001+\u0003\u0011\u0011\u0017m]3\u0016\u0003-\u00022!\u0003\u0017/\u0013\ti#B\u0001\u0004PaRLwN\u001c\t\u0003E=J!\u0001M\u0012\u0003\u000f\r{g\u000e^3yi\"A!\u0007\u0001B\u0001B\u0003%1&A\u0003cCN,\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u00016\u0003%iW\rZ5b)f\u0004X-F\u00017!\rIA&\u0005\u0005\tq\u0001\u0011\t\u0011)A\u0005m\u0005QQ.\u001a3jCRK\b/\u001a\u0011\t\u0011i\u0002!Q1A\u0005\u0002A\taA^3oI>\u0014\b\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002\u000fY,g\u000eZ8sA!Aa\b\u0001BC\u0002\u0013\u0005q(A\u0007sK\u001a,'/\u001a8dK.Kg\u000eZ\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111IA\u0001\u0007a\u0006\u00148/\u001a:\n\u0005\u0015\u0013%!\u0004*fM\u0016\u0014XM\\2f\u0017&tG\r\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003A\u00039\u0011XMZ3sK:\u001cWmS5oI\u0002B\u0001\"\u0013\u0001\u0003\u0006\u0004%IAS\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002\u0017B\u0011!\u0005T\u0005\u0003\u001b\u000e\u0012QaQ1dQ\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006IaS\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u0011E\u0003!Q1A\u0005\nI\u000b1BY1tK\u000e{g\u000e^3yiV\t1\u000bE\u0002\nYQ\u0003\"!Q+\n\u0005Y\u0013%!\u0004)beN,'oQ8oi\u0016DH\u000f\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003T\u00031\u0011\u0017m]3D_:$X\r\u001f;!\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003\u0019a\u0014N\\5u}QIALX0aC\n\u001cG-\u001a\t\u0003;\u0002i\u0011A\u0001\u0005\u0006\u001fe\u0003\r!\u0005\u0005\u0006?e\u0003\r!\t\u0005\u0006Se\u0003\ra\u000b\u0005\u0006ie\u0003\rA\u000e\u0005\u0006ue\u0003\r!\u0005\u0005\u0006}e\u0003\r\u0001\u0011\u0005\u0006\u0013f\u0003\ra\u0013\u0005\b#f\u0003\n\u00111\u0001T\u0011\u001d9\u0007A1A\u0005\u0002!\f1!\u001e:m+\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0011a\u0017M\\4\u000b\u00039\fAA[1wC&\u0011!d\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B5\u0002\tU\u0014H\u000e\t\u0005\tg\u0002A)\u0019!C\u0005i\u000691m\u001c8uKb$X#\u0001\u0018\t\u0011Y\u0004\u0001R1A\u0005\nA\t\u0001\u0002\\8dCRLwN\u001c\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0003\r\u0019G\u000f_\u000b\u0002)\"11\u0010\u0001Q\u0001\nQ\u000bAa\u0019;yA!)Q\u0010\u0001C\u0001}\u0006)!-^5mIR\tq\u0010\u0005\u0004\u0002\u0002\u0005\u001d\u00111B\u0007\u0003\u0003\u0007Q1!!\u0002\u000b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0004GkR,(/\u001a\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003!!wnY;nK:$(bAA\u000b\u0005\u0005)Qn\u001c3fY&!\u0011\u0011DA\b\u0005!\u0011\u0015m]3V]&$\bBBA\u000f\u0001\u0011%a0A\u0004d_6\u0004\u0018\u000e\\3\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u0005Y\u0001/\u0019:tKNKh\u000e^1y)\u0011\t)#a\u0011\u0011\u0011\u0005\u001d\u0012\u0011GA\u001c\u0003{qA!!\u000b\u0002.9\u0019A#a\u000b\n\u0003-I1!a\f\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\r\u00026\t1Q)\u001b;iKJT1!a\f\u000b!\r\u0011\u0013\u0011H\u0005\u0004\u0003w\u0019#aB\"p]R,g\u000e\u001e\t\u0004;\u0006}\u0012bAA!\u0005\t!!k\\8u\u0011!\t)%a\bA\u0002\u0005]\u0012\u0001D5oaV$8i\u001c8uK:$\bbBA%\u0001\u0011\u0005\u00111J\u0001\u0016a\u0006\u00148/Z#yi\u0016\u0014h.\u00197Ge\u0006<W.\u001a8u)\ry\u0018Q\n\u0005\t\u0003\u001f\n9\u00051\u0001\u00028\u000591m\u001c8uK:$\bbBA*\u0001\u0011%\u0011QK\u0001\fa\u0006\u00148/\u001a#p[\u0006Lg\u000eF\u0002\u0000\u0003/B\u0001\"!\u0017\u0002R\u0001\u0007\u0011QE\u0001\u0007a\u0006\u00148/\u001a3\t\u000f\u0005M\u0003\u0001\"\u0003\u0002^Q\u0019q0a\u0018\t\u0011\u0005E\u00111\fa\u0001\u0003{Aq!a\u0019\u0001\t\u0013\t)'A\bqCJ\u001cXMU3gKJ,gnY3t)\u0019\t9'!\u001b\u0002nA1\u0011\u0011AA\u0004\u0003{A\u0001\"a\u001b\u0002b\u0001\u0007\u0011QH\u0001\u0005e>|G\u000f\u0003\u0005\u0002p\u0005\u0005\u0004\u0019AA9\u00031!w.\\1j]BcWoZ5o!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<\u0005\u00059\u0001\u000f\\;hS:\u001c\u0018\u0002BA>\u0003k\u0012\u0011#Q'G\t>\u001cW/\\3oiBcWoZ5o\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003\u000bqA]3t_24X\r\u0006\u0002\u0002\u0004B1\u0011\u0011AA\u0004\u0003oAq!a\u001b\u0001\t\u0003\t9\t\u0006\u0002\u0002h\u001d9\u00111\u0012\u0002\t\u0002\u00055\u0015aC!N\r\u000e{W\u000e]5mKJ\u00042!XAH\r\u0019\t!\u0001#\u0001\u0002\u0012N\u0019\u0011q\u0012\u0005\t\u000fi\u000by\t\"\u0001\u0002\u0016R\u0011\u0011Q\u0012\u0005\t\u00033\u000by\t\"\u0001\u0002\u001c\u0006!\u0011N\\5u)\t\ti\nE\u0002\n\u0003?K1!!)\u000b\u0005\u0011)f.\u001b;\t\u0015\u0005\u0015\u0016qRI\u0001\n\u0003\t9+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003SS3aUAVW\t\ti\u000b\u0005\u0003\u00020\u0006eVBAAY\u0015\u0011\t\u0019,!.\u0002\u0013Ut7\r[3dW\u0016$'bAA\\\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0016\u0011\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class AMFCompiler {
    private Context context;
    private String location;
    private final String rawUrl;
    private final Platform remote;
    private final Option<Context> base;
    private final Option<String> mediaType;
    private final String vendor;
    private final ReferenceKind referenceKind;
    private final Cache cache;
    private final Option<ParserContext> baseContext;
    private final String url;
    private final ParserContext amf$core$AMFCompiler$$ctx;
    private volatile byte bitmap$0;

    public static Option<ParserContext> $lessinit$greater$default$8() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$8();
    }

    public static void init() {
        AMFCompiler$.MODULE$.init();
    }

    public String rawUrl() {
        return this.rawUrl;
    }

    public Platform remote() {
        return this.remote;
    }

    public Option<Context> base() {
        return this.base;
    }

    public Option<String> mediaType() {
        return this.mediaType;
    }

    public String vendor() {
        return this.vendor;
    }

    public ReferenceKind referenceKind() {
        return this.referenceKind;
    }

    private Cache cache() {
        return this.cache;
    }

    private Option<ParserContext> baseContext() {
        return this.baseContext;
    }

    public String url() {
        return this.url;
    }

    private Context context$lzycompute() {
        AMFCompiler aMFCompiler = this;
        synchronized (aMFCompiler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.context = (Context)this.base().map((Function1<Context, Context> & Serializable & scala.Serializable)x$1 -> x$1.update(this.url())).getOrElse((Function0<Context> & Serializable & scala.Serializable)() -> Context$.MODULE$.apply(this.remote(), this.url()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.context;
    }

    private Context context() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.context$lzycompute() : this.context;
    }

    private String location$lzycompute() {
        AMFCompiler aMFCompiler = this;
        synchronized (aMFCompiler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.location = this.context().current();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.location;
    }

    private String location() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.location$lzycompute() : this.location;
    }

    public ParserContext amf$core$AMFCompiler$$ctx() {
        return this.amf$core$AMFCompiler$$ctx;
    }

    public Future<BaseUnit> build() {
        return this.context().hasCycles() ? Future$.MODULE$.failed(new CyclicReferenceException(this.context().history())) : this.cache().getOrUpdate(this.location(), (Function0<Future<BaseUnit>>)(Function0<Future> & Serializable & scala.Serializable)() -> this.compile());
    }

    private Future<BaseUnit> compile() {
        return this.resolve().map((Function1<Content, Either> & Serializable & scala.Serializable)inputContent -> this.parseSyntax((Content)inputContent), ExecutionContext$Implicits$.MODULE$.global()).flatMap((Function1<Either, Future> & Serializable & scala.Serializable)parsed -> this.parseDomain((Either<Content, Root>)parsed), ExecutionContext$Implicits$.MODULE$.global());
    }

    private Either<Content, Root> parseSyntax(Content inputContent) {
        Either either;
        Content content = AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft(inputContent, (Function2<Content, AMFFeaturePlugin, Content> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2<Content, AMFFeaturePlugin> tuple2 = new Tuple2<Content, AMFFeaturePlugin>((Content)x0$1, (AMFFeaturePlugin)x1$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Content input = tuple2._1();
            AMFFeaturePlugin plugin = tuple2._2();
            Content content = plugin.onBeginDocumentParsing(this.url(), input, this.referenceKind(), this.vendor());
            return content;
        });
        Option parsed = content.mime().orElse((Function0<Option> & Serializable & scala.Serializable)() -> this.mediaType()).flatMap((Function1<String, Option> & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1<AMFSyntaxPlugin, Option> & Serializable & scala.Serializable)x$2 -> x$2.parse((String)mime, content.stream(), this.amf$core$AMFCompiler$$ctx()))).orElse((Function0<Option> & Serializable & scala.Serializable)() -> FileMediaType$.MODULE$.extension(content.url()).flatMap((Function1<String, Option> & Serializable & scala.Serializable)extension -> FileMediaType$.MODULE$.mimeFromExtension((String)extension)).flatMap((Function1<String, Option> & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1<AMFSyntaxPlugin, Option> & Serializable & scala.Serializable)x$3 -> x$3.parse((String)mime, content.stream(), this.amf$core$AMFCompiler$$ctx()))));
        Option option = parsed;
        if (option instanceof Some) {
            Some some = (Some)option;
            ParsedDocument inputDocument = (ParsedDocument)some.value();
            ParsedDocument document = AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft(inputDocument, (Function2<ParsedDocument, AMFFeaturePlugin, ParsedDocument> & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2<ParsedDocument, AMFFeaturePlugin> tuple2 = new Tuple2<ParsedDocument, AMFFeaturePlugin>((ParsedDocument)x0$2, (AMFFeaturePlugin)x1$2);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                ParsedDocument doc = tuple2._1();
                AMFFeaturePlugin plugin = tuple2._2();
                ParsedDocument parsedDocument = plugin.onSyntaxParsed(this.url(), doc);
                return parsedDocument;
            });
            either = package$.MODULE$.Right().apply(new Root(document, content.url(), (String)content.mime().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> (String)this.mediaType().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")), (Seq)Seq$.MODULE$.apply(Nil$.MODULE$), this.referenceKind(), this.vendor(), content.stream().toString()));
        } else if (None$.MODULE$.equals(option)) {
            either = package$.MODULE$.Left().apply(content);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    public Future<BaseUnit> parseExternalFragment(Content content) {
        ExternalDomainElement result2 = ExternalDomainElement$.MODULE$.apply().withRaw(content.stream().toString());
        content.mime().foreach((Function1<String, ExternalDomainElement> & Serializable & scala.Serializable)mime -> result2.withMediaType((String)mime));
        return Future$.MODULE$.successful(((BaseUnit)((Object)((EncodesModel)ExternalFragment$.MODULE$.apply().withId(content.url())).withEncodes(result2))).withLocation(content.url()));
    }

    private Future<BaseUnit> parseDomain(Either<Content, Root> parsed) {
        Future<BaseUnit> future;
        Either<Content, Root> either = parsed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Content content = (Content)left.value();
            future = this.parseExternalFragment(content);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Root document = (Root)right.value();
            future = this.parseDomain(document);
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    private Future<BaseUnit> parseDomain(Root document) {
        Future<Object> future;
        Option domainPluginOption;
        Option option;
        Option option2 = AMFPluginsRegistry$.MODULE$.documentPluginForVendor(this.vendor()).find((Function1<AMFDocumentPlugin, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.canParse(document)));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
            option = new Some<AMFDocumentPlugin>(domainPlugin);
        } else if (None$.MODULE$.equals(option2)) {
            option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(document.mediatype()).find((Function1<AMFDocumentPlugin, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.canParse(document)));
        } else {
            throw new MatchError(option2);
        }
        Option option3 = domainPluginOption = option;
        if (option3 instanceof Some) {
            Option option4 = option3;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)((Some)option4).value();
            future = this.parseReferences(document, domainPlugin).map((Function1<Root, BaseUnit> & Serializable & scala.Serializable)documentWithReferences -> {
                BaseUnit baseUnit;
                Option<BaseUnit> option = domainPlugin.parse((Root)documentWithReferences, this.amf$core$AMFCompiler$$ctx(), this.remote());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BaseUnit baseUnit2 = (BaseUnit)some.value();
                    baseUnit = baseUnit2.withRaw(document.raw());
                } else if (None$.MODULE$.equals(option)) {
                    baseUnit = (BaseUnit)((Object)((EncodesModel)ExternalFragment$.MODULE$.apply().withId(document.location())).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype())));
                } else {
                    throw new MatchError(option);
                }
                return baseUnit;
            }, ExecutionContext$Implicits$.MODULE$.global());
        } else if (None$.MODULE$.equals(option3)) {
            ExternalFragment fragment = (ExternalFragment)((EncodesModel)ExternalFragment$.MODULE$.apply().withId(document.location())).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype()));
            future = Future$.MODULE$.successful(fragment);
        } else {
            throw new MatchError(option3);
        }
        Future futureDocument = future;
        return futureDocument.map((Function1<BaseUnit, BaseUnit> & Serializable & scala.Serializable)baseUnit -> AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft(baseUnit, (Function2<BaseUnit, AMFFeaturePlugin, BaseUnit> & Serializable & scala.Serializable)(x0$3, x1$3) -> {
            Tuple2<BaseUnit, AMFFeaturePlugin> tuple2 = new Tuple2<BaseUnit, AMFFeaturePlugin>((BaseUnit)x0$3, (AMFFeaturePlugin)x1$3);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BaseUnit unit = tuple2._1();
            AMFFeaturePlugin plugin = tuple2._2();
            BaseUnit baseUnit = plugin.onModelParsed(this.url(), unit);
            return baseUnit;
        }), ExecutionContext$Implicits$.MODULE$.global());
    }

    private Future<Root> parseReferences(Root root2, AMFDocumentPlugin domainPlugin) {
        ReferenceHandler handler = domainPlugin.referenceHandler();
        Seq<Reference> refs = handler.collect(root2.parsed(), this.amf$core$AMFCompiler$$ctx());
        Seq units = ((TraversableLike)((TraversableLike)refs.distinct()).filter((Function1<Reference, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isRemote()))).map((Function1<Reference, Future> & Serializable & scala.Serializable)link -> link.resolve(this.context(), None$.MODULE$, domainPlugin.ID(), this.cache(), this.amf$core$AMFCompiler$$ctx()).flatMap((Function1<BaseUnit, Future> & Serializable & scala.Serializable)u -> {
            ParsedReference reference = new ParsedReference((BaseUnit)u, (Reference)link, ParsedReference$.MODULE$.apply$default$3());
            return handler.update(reference, this.amf$core$AMFCompiler$$ctx(), this.context()).map((Function1<ParsedReference, Some> & Serializable & scala.Serializable)x$7 -> new Some<ParsedReference>((ParsedReference)x$7), ExecutionContext$Implicits$.MODULE$.global());
        }, ExecutionContext$Implicits$.MODULE$.global()).recover(new scala.Serializable(this, (Reference)link){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AMFCompiler $outer;
            private final Reference link$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof FileNotFound) {
                    FileNotFound fileNotFound = (FileNotFound)A1;
                    this.$outer.amf$core$AMFCompiler$$ctx().violation(this.link$1.url(), fileNotFound.getMessage(), this.link$1.ast());
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof FileNotFound;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.link$1 = link$1;
            }
        }, ExecutionContext$Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence(units, Seq$.MODULE$.canBuildFrom(), ExecutionContext$Implicits$.MODULE$.global()).map((Function1<Seq, Root> & Serializable & scala.Serializable)rs -> {
            Seq x$9 = (Seq)rs.flatten((Function1<Option, Iterable> & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            String x$10 = domainPlugin.ID();
            ParsedDocument x$11 = root2.copy$default$1();
            String x$12 = root2.copy$default$2();
            String x$13 = root2.copy$default$3();
            ReferenceKind x$14 = root2.copy$default$5();
            String x$15 = root2.copy$default$7();
            return root2.copy(x$11, x$12, x$13, x$9, x$14, x$10, x$15);
        }, ExecutionContext$Implicits$.MODULE$.global());
    }

    private Future<Content> resolve() {
        return this.remote().resolve(this.location(), this.base());
    }

    public Future<Root> root() {
        return this.resolve().map((Function1<Content, Either> & Serializable & scala.Serializable)inputContent -> this.parseSyntax((Content)inputContent), ExecutionContext$Implicits$.MODULE$.global()).flatMap((Function1<Either, Future> & Serializable & scala.Serializable)x0$4 -> {
            Right right;
            Root document;
            Either either = x0$4;
            if (either instanceof Right && (document = (Root)(right = (Right)either).value()) != null) {
                void var3_11;
                Root root2 = document;
                Option option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(root2.mediatype()).find((Function1<AMFDocumentPlugin, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(x$8.canParse(root2)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
                    Future<Root> future = this.parseReferences(root2, domainPlugin);
                    return var3_11;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    Future future = Future$.MODULE$.apply((Function0<Root> & Serializable & scala.Serializable)() -> root2, ExecutionContext$Implicits$.MODULE$.global());
                }
                return var3_11;
            }
            if (!(either instanceof Left)) throw new MatchError(either);
            Left left = (Left)either;
            Content content = (Content)left.value();
            throw new Exception(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse document with mime type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{content.mime().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "none")})));
        }, ExecutionContext$Implicits$.MODULE$.global());
    }

    public AMFCompiler(String rawUrl, Platform remote2, Option<Context> base, Option<String> mediaType, String vendor, ReferenceKind referenceKind, Cache cache, Option<ParserContext> baseContext) {
        this.rawUrl = rawUrl;
        this.remote = remote2;
        this.base = base;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.referenceKind = referenceKind;
        this.cache = cache;
        this.baseContext = baseContext;
        this.url = new URI(rawUrl).normalize().toString();
        this.amf$core$AMFCompiler$$ctx = (ParserContext)baseContext.getOrElse((Function0<ParserContext> & Serializable & scala.Serializable)() -> new ParserContext(this.url(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3()));
    }
}

