/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.features.validation;

import amf.ProfileNames$;
import amf.core.client.GenerationOptions$;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.Document;
import amf.core.model.domain.DomainElement;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.plugins.AMFPlugin;
import amf.core.plugins.AMFValidationPlugin;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Context$;
import amf.core.remote.Platform;
import amf.core.services.RuntimeCompiler$;
import amf.core.services.RuntimeSerializer$;
import amf.core.services.RuntimeValidator$;
import amf.core.unsafe.PlatformSecrets;
import amf.core.validation.AMFValidationReport;
import amf.core.validation.AMFValidationResult;
import amf.core.validation.EffectiveValidations;
import amf.core.validation.EffectiveValidations$;
import amf.core.validation.core.ValidationProfile;
import amf.core.validation.core.ValidationReport;
import amf.core.validation.core.ValidationSpecification;
import amf.plugins.document.graph.AMFGraphPlugin$;
import amf.plugins.document.vocabularies.RAMLVocabulariesPlugin$;
import amf.plugins.document.vocabularies.model.domain.DomainEntity;
import amf.plugins.document.vocabularies.spec.Dialect;
import amf.plugins.features.validation.ParserSideValidationPlugin;
import amf.plugins.features.validation.PlatformValidator$;
import amf.plugins.features.validation.ValidationMutex$;
import amf.plugins.features.validation.emitters.JSLibraryEmitter;
import amf.plugins.features.validation.emitters.ValidationJSONLDEmitter;
import amf.plugins.features.validation.emitters.ValidationJSONLDEmitter$;
import amf.plugins.features.validation.model.ParsedValidationProfile$;
import amf.plugins.features.validation.model.ValidationDialectText$;
import amf.plugins.syntax.SYamlSyntaxPlugin$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext$Implicits$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AMFValidatorPlugin$
extends ParserSideValidationPlugin
implements PlatformSecrets {
    public static AMFValidatorPlugin$ MODULE$;
    private final String ID;
    private final String url;
    private Map<String, Function0<ValidationProfile>> customValidationProfiles;
    private Map<String, AMFDocumentPlugin> customValidationProfilesPlugins;
    private final Platform platform;

    static {
        new AMFValidatorPlugin$();
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @Override
    public void amf$core$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    @Override
    public String ID() {
        return this.ID;
    }

    @Override
    public Future<AMFPlugin> init() {
        RuntimeValidator$.MODULE$.register(this);
        String url = "http://raml.org/dialects/profile.raml";
        return RAMLVocabulariesPlugin$.MODULE$.registerDialect(url, ValidationDialectText$.MODULE$.text()).map((Function1<Dialect, AMFValidatorPlugin$> & Serializable & scala.Serializable)x$1 -> this, ExecutionContext$Implicits$.MODULE$.global());
    }

    @Override
    public Seq<AMFPlugin> dependencies() {
        return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new AMFPlugin[]{SYamlSyntaxPlugin$.MODULE$, RAMLVocabulariesPlugin$.MODULE$, AMFGraphPlugin$.MODULE$}));
    }

    public String url() {
        return this.url;
    }

    public Map<String, Function0<ValidationProfile>> profiles() {
        return ((MapLike)AMFPluginsRegistry$.MODULE$.documentPlugins().foldLeft(Predef$.MODULE$.Map().apply(Nil$.MODULE$), (Function2<Map, AMFDocumentPlugin, Map> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2<Map, AMFDocumentPlugin> tuple2 = new Tuple2<Map, AMFDocumentPlugin>((Map)x0$1, (AMFDocumentPlugin)x1$1);
            if (tuple2 != null) {
                Map acc = tuple2._1();
                AMFDocumentPlugin domainPlugin = tuple2._2();
                if (domainPlugin instanceof AMFValidationPlugin) {
                    AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                    return acc.$plus$plus(((AMFValidationPlugin)((Object)aMFDocumentPlugin)).domainValidationProfiles(this.platform()));
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            Map acc = tuple2._1();
            return acc;
        })).$plus$plus(this.customValidationProfiles());
    }

    public Map<String, AMFDocumentPlugin> profilesPlugins() {
        return ((MapLike)AMFPluginsRegistry$.MODULE$.documentPlugins().foldLeft(Predef$.MODULE$.Map().apply(Nil$.MODULE$), (Function2<Map, AMFDocumentPlugin, Map> & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2<Map, AMFDocumentPlugin> tuple2 = new Tuple2<Map, AMFDocumentPlugin>((Map)x0$2, (AMFDocumentPlugin)x1$2);
            if (tuple2 != null) {
                Map acc = tuple2._1();
                AMFDocumentPlugin domainPlugin = tuple2._2();
                if (domainPlugin instanceof AMFValidationPlugin) {
                    AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                    return acc.$plus$plus((GenTraversableOnce)((AMFValidationPlugin)((Object)aMFDocumentPlugin)).domainValidationProfiles(this.platform()).keys().foldLeft(Predef$.MODULE$.Map().apply(Nil$.MODULE$), (Function2<Map, String, Map> & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                        Tuple2<Map, String> tuple2 = new Tuple2<Map, String>((Map)x0$3, (String)x1$3);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Map accProfiles = tuple2._1();
                        String profileName = tuple2._2();
                        Map<String, AMFDocumentPlugin> map = accProfiles.updated(profileName, aMFDocumentPlugin);
                        return map;
                    }));
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            Map acc = tuple2._1();
            return acc;
        })).$plus$plus(this.customValidationProfilesPlugins());
    }

    public Map<String, Function0<ValidationProfile>> customValidationProfiles() {
        return this.customValidationProfiles;
    }

    public void customValidationProfiles_$eq(Map<String, Function0<ValidationProfile>> x$1) {
        this.customValidationProfiles = x$1;
    }

    public Map<String, AMFDocumentPlugin> customValidationProfilesPlugins() {
        return this.customValidationProfilesPlugins;
    }

    public void customValidationProfilesPlugins_$eq(Map<String, AMFDocumentPlugin> x$1) {
        this.customValidationProfilesPlugins = x$1;
    }

    @Override
    public Future<String> loadValidationProfile(String validationProfilePath) {
        return RuntimeCompiler$.MODULE$.apply(validationProfilePath, Option$.MODULE$.apply("application/yaml"), RAMLVocabulariesPlugin$.MODULE$.ID(), Context$.MODULE$.apply(this.platform()), RuntimeCompiler$.MODULE$.apply$default$5(), RuntimeCompiler$.MODULE$.apply$default$6(), RuntimeCompiler$.MODULE$.apply$default$7()).map((Function1<BaseUnit, DomainElement> & Serializable & scala.Serializable)x0$4 -> {
            BaseUnit baseUnit = x0$4;
            if (!(baseUnit instanceof Document)) {
                throw new MatchError(baseUnit);
            }
            Document document = (Document)baseUnit;
            DomainElement domainElement = document.encodes();
            return domainElement;
        }, ExecutionContext$Implicits$.MODULE$.global()).map((Function1<DomainElement, String> & Serializable & scala.Serializable)x0$5 -> {
            AMFDocumentPlugin aMFDocumentPlugin;
            DomainElement domainElement = x0$5;
            if (!(domainElement instanceof DomainEntity)) throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
            DomainEntity domainEntity = (DomainEntity)domainElement;
            String string = domainEntity.definition().shortName();
            String string2 = "Profile";
            if (string == null) {
                if (string2 != null) {
                    throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
                }
            } else if (!string.equals(string2)) throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
            ValidationProfile profile = ParsedValidationProfile$.MODULE$.apply(domainEntity);
            Option option = this.profilesPlugins().get(profile.name());
            if (option instanceof Some) {
                AMFDocumentPlugin plugin;
                Some some = (Some)option;
                aMFDocumentPlugin = plugin = (AMFDocumentPlugin)some.value();
            } else {
                AMFDocumentPlugin plugin;
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                Option option2 = this.profilesPlugins().get((String)profile.baseProfileName().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "AMF"));
                if (!(option2 instanceof Some)) {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    throw new Exception(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plugin for custom validation profile ", ", ", " not found"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{profile.name(), profile.baseProfileName()})));
                }
                Some some = (Some)option2;
                AMFDocumentPlugin aMFDocumentPlugin2 = plugin = (AMFDocumentPlugin)some.value();
                aMFDocumentPlugin = aMFDocumentPlugin2;
            }
            AMFDocumentPlugin domainPlugin = aMFDocumentPlugin;
            this.customValidationProfiles_$eq(this.customValidationProfiles().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(profile.name()), (Function0<ValidationProfile> & Serializable & scala.Serializable)() -> profile)));
            this.customValidationProfilesPlugins_$eq(this.customValidationProfilesPlugins().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(profile.name()), domainPlugin)));
            return profile.name();
        }, ExecutionContext$Implicits$.MODULE$.global());
    }

    public EffectiveValidations computeValidations(String profileName, EffectiveValidations computed) {
        EffectiveValidations effectiveValidations;
        None$ maybeProfile;
        Option option;
        Option option2 = this.profiles().get(profileName);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Function0 profileGenerator = (Function0)some.value();
            option = new Some(profileGenerator.apply());
        } else {
            option = None$.MODULE$;
        }
        None$ none$ = maybeProfile = option;
        if (none$ instanceof Some) {
            Some some = (Some)((Object)none$);
            ValidationProfile foundProfile = (ValidationProfile)some.value();
            effectiveValidations = foundProfile.baseProfileName().isDefined() ? this.computeValidations(foundProfile.baseProfileName().get(), computed).someEffective(foundProfile) : computed.someEffective(foundProfile);
        } else if (None$.MODULE$.equals(none$)) {
            effectiveValidations = computed;
        } else {
            throw new MatchError(none$);
        }
        return effectiveValidations;
    }

    public EffectiveValidations computeValidations$default$2() {
        return new EffectiveValidations(EffectiveValidations$.MODULE$.$lessinit$greater$default$1(), EffectiveValidations$.MODULE$.$lessinit$greater$default$2(), EffectiveValidations$.MODULE$.$lessinit$greater$default$3(), EffectiveValidations$.MODULE$.$lessinit$greater$default$4(), EffectiveValidations$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Future<ValidationReport> shaclValidation(BaseUnit model, EffectiveValidations validations, String messageStyle) {
        Future<ValidationReport> future;
        String shapesJSON = this.shapesGraph(validations, messageStyle);
        Option<String> jsLibrary = new JSLibraryEmitter(None$.MODULE$).emitJS(validations.effective().values().toSeq());
        Option<String> option = jsLibrary;
        if (option instanceof Some) {
            Some some = (Some)option;
            String code = (String)some.value();
            PlatformValidator$.MODULE$.instance().registerLibrary(ValidationJSONLDEmitter$.MODULE$.validationLibraryUrl(), code);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        String modelJSON = RuntimeSerializer$.MODULE$.apply(model, "application/ld+json", "AMF Graph", GenerationOptions$.MODULE$.apply());
        ValidationMutex$ validationMutex$ = ValidationMutex$.MODULE$;
        synchronized (validationMutex$) {
            future = PlatformValidator$.MODULE$.instance().report(modelJSON, "application/ld+json", shapesJSON, "application/ld+json");
        }
        return future;
    }

    @Override
    public Future<AMFValidationReport> validate(BaseUnit model, String profileName, String messageStyle) {
        return super.validate(model, profileName, messageStyle).flatMap((Function1<AMFValidationReport, Future> & Serializable & scala.Serializable)parserSideValidation -> {
            Future<Object> future;
            Some some;
            AMFDocumentPlugin domainPlugin;
            Option option = this.profilesPlugins().get(profileName);
            if (option instanceof Some && (domainPlugin = (AMFDocumentPlugin)(some = (Some)option).value()) instanceof AMFValidationPlugin) {
                AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                EffectiveValidations validations = this.computeValidations(profileName, this.computeValidations$default$2());
                future = ((AMFValidationPlugin)((Object)aMFDocumentPlugin)).validationRequest(model, profileName, validations, this.platform()).map((Function1<AMFValidationReport, AMFValidationReport> & Serializable & scala.Serializable)modelValidations -> {
                    boolean x$2 = modelValidations.conforms() && parserSideValidation.conforms();
                    Seq<AMFValidationResult> x$3 = modelValidations.results().$plus$plus(parserSideValidation.results(), Seq$.MODULE$.canBuildFrom());
                    String x$4 = modelValidations.copy$default$2();
                    String x$5 = modelValidations.copy$default$3();
                    return modelValidations.copy(x$2, x$4, x$5, x$3);
                }, ExecutionContext$Implicits$.MODULE$.global());
            } else {
                future = Future$.MODULE$.apply((Function0<AMFValidationReport> & Serializable & scala.Serializable)() -> this.profileNotFoundWarningReport(model, profileName), ExecutionContext$Implicits$.MODULE$.global());
            }
            return future;
        }, ExecutionContext$Implicits$.MODULE$.global());
    }

    public AMFValidationReport profileNotFoundWarningReport(BaseUnit model, String profileName) {
        return new AMFValidationReport(true, model.location(), profileName, (Seq)Seq$.MODULE$.apply(Nil$.MODULE$));
    }

    public String shapesGraph(EffectiveValidations validations, String messageStyle) {
        return new ValidationJSONLDEmitter(messageStyle).emitJSON((Seq)validations.effective().values().toSeq().filter((Function1<ValidationSpecification, Object> & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean(AMFValidatorPlugin$.$anonfun$shapesGraph$1(s))));
    }

    public String shapesGraph$default$2() {
        return ProfileNames$.MODULE$.RAML();
    }

    public static final /* synthetic */ boolean $anonfun$shapesGraph$1(ValidationSpecification s) {
        return !s.isParserSide();
    }

    private AMFValidatorPlugin$() {
        MODULE$ = this;
        PlatformSecrets.$init$(this);
        this.ID = "AMF Validation";
        this.url = "http://raml.org/dialects/profile.raml";
        this.customValidationProfiles = Predef$.MODULE$.Map().empty();
        this.customValidationProfilesPlugins = Predef$.MODULE$.Map().empty();
    }
}

