/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Cons;
import com.github.andrewoma.dexx.collection.ConsListIterator;
import com.github.andrewoma.dexx.collection.LinkedList;
import com.github.andrewoma.dexx.collection.Nil;
import com.github.andrewoma.dexx.collection.Vector;
import com.github.andrewoma.dexx.collection.internal.base.AbstractLinkedList;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractBuilder;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class ConsList<E>
extends AbstractLinkedList<E> {
    private static final ConsList<Object> EMPTY = new Nil<Object>();

    @NotNull
    public static <E> BuilderFactory<E, ConsList<E>> factory() {
        return new BuilderFactory<E, ConsList<E>>(){

            @Override
            @NotNull
            public Builder<E, ConsList<E>> newBuilder() {
                return new AbstractBuilder<E, ConsList<E>>(){
                    private Vector<E> buffer = Vector.empty();

                    @Override
                    @NotNull
                    public Builder<E, ConsList<E>> add(E element) {
                        this.buffer = this.buffer.append(element);
                        return this;
                    }

                    @Override
                    @NotNull
                    public ConsList<E> doBuild() {
                        LinkedList result2 = ConsList.empty();
                        for (int i = this.buffer.size() - 1; i >= 0; --i) {
                            result2 = result2.prepend(this.buffer.get(i));
                        }
                        return result2;
                    }
                };
            }
        };
    }

    public static <E> ConsList<E> empty() {
        return EMPTY;
    }

    @Override
    @NotNull
    public ConsList<E> prepend(E elem) {
        return new Cons<E>(elem, this);
    }

    @Override
    @NotNull
    public abstract ConsList<E> append(E var1);

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new ConsListIterator(this);
    }

    @Override
    @NotNull
    public abstract ConsList<E> range(int var1, boolean var2, int var3, boolean var4);

    @Override
    @NotNull
    public abstract ConsList<E> tail();

    @Override
    @NotNull
    public abstract ConsList<E> take(int var1);

    @Override
    @NotNull
    public abstract ConsList<E> drop(int var1);

    @Override
    @NotNull
    public abstract ConsList<E> set(int var1, E var2);
}

