/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.HashMap;
import com.github.andrewoma.dexx.collection.Map;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.Traversable;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Maps {
    private Maps() {
    }

    @NotNull
    public static <K, V> Map<K, V> of() {
        return Maps.construct(new Pair[0]);
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k, V v) {
        return Maps.construct(Maps.p(k, v));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2), Maps.p(k3, v3));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2), Maps.p(k3, v3), Maps.p(k4, v4));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2), Maps.p(k3, v3), Maps.p(k4, v4), Maps.p(k5, v5));
    }

    private static <K, V> Pair<K, V> p(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    private static <K, V> Map<K, V> construct(Pair<K, V> ... pairs) {
        Map<K, V> map = HashMap.empty();
        for (Pair<K, V> pair : pairs) {
            map = map.put(pair.component1(), pair.component2());
        }
        return map;
    }

    @NotNull
    public static <K, V> Map<K, V> copyOf(Iterable<Pair<K, V>> iterable) {
        Map result2 = HashMap.empty();
        for (Pair<K, V> pair : iterable) {
            result2 = result2.put((Object)pair.component1(), (Object)pair.component2());
        }
        return result2;
    }

    @NotNull
    public static <K, V> Map<K, V> copyOf(Iterator<Pair<K, V>> iterator) {
        Map result2 = HashMap.empty();
        while (iterator.hasNext()) {
            Pair<K, V> pair = iterator.next();
            result2 = result2.put((Object)pair.component1(), (Object)pair.component2());
        }
        return result2;
    }

    @NotNull
    public static <K, V> Map<K, V> copyOf(Pair<K, V>[] pairs) {
        Map result2 = HashMap.empty();
        for (Pair<K, V> pair : pairs) {
            result2 = result2.put((Object)pair.component1(), (Object)pair.component2());
        }
        return result2;
    }

    @NotNull
    public static <K, V> Map<K, V> copyOfTraversable(Traversable<Pair<K, V>> traversable) {
        final HashMap[] result2 = new HashMap[]{HashMap.empty()};
        traversable.forEach(new Function<Pair<K, V>, Object>(){

            @Override
            public Object invoke(Pair<K, V> pair) {
                result2[0] = result2[0].put(pair.component1(), pair.component2());
                return null;
            }
        });
        return result2[0];
    }

    @NotNull
    public static <K, V> BuilderFactory<Pair<K, V>, Map<K, V>> factory() {
        return HashMap.factory();
    }

    @NotNull
    public static <K, V> Builder<Pair<K, V>, Map<K, V>> builder() {
        return Maps.factory().newBuilder();
    }
}

