/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonUtils;
import java.net.URL;
import org.apache.http.impl.client.CloseableHttpClient;

public class DocumentLoader {
    public static final String DISALLOW_REMOTE_CONTEXT_LOADING = "com.github.jsonldjava.disallowRemoteContextLoading";
    @Deprecated
    public static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    private volatile CloseableHttpClient httpClient;

    public RemoteDocument loadDocument(String url) throws JsonLdError {
        String disallowRemote = System.getProperty(DISALLOW_REMOTE_CONTEXT_LOADING);
        if ("true".equalsIgnoreCase(disallowRemote)) {
            throw new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, "Remote context loading has been disallowed (url was " + url + ")");
        }
        RemoteDocument doc = new RemoteDocument(url, null);
        try {
            doc.setDocument(JsonUtils.fromURL(new URL(url), this.getHttpClient()));
        }
        catch (Exception e2) {
            throw new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, url, e2);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CloseableHttpClient getHttpClient() {
        CloseableHttpClient result2 = this.httpClient;
        if (result2 != null) return result2;
        Class<DocumentLoader> clazz = DocumentLoader.class;
        synchronized (DocumentLoader.class) {
            result2 = this.httpClient;
            if (result2 != null) return result2;
            this.httpClient = JsonUtils.getDefaultHttpClient();
            return this.httpClient;
        }
    }

    public void setHttpClient(CloseableHttpClient nextHttpClient) {
        this.httpClient = nextHttpClient;
    }
}

