/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.assembler.AssemblerHelp;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ModelExpansion {
    private static final Property ANY = null;

    public static Model withSchema(Model model, Model schema) {
        Model result2 = ModelFactory.createDefaultModel().add(model);
        ModelExpansion.addSubclassesFrom(result2, schema);
        ModelExpansion.addSubClassClosure(result2);
        ModelExpansion.addDomainTypes(result2, schema);
        ModelExpansion.addRangeTypes(result2, schema);
        ModelExpansion.addIntersections(result2, schema);
        ModelExpansion.addSupertypes(result2);
        return result2;
    }

    protected static void addSubclassesFrom(Model result2, Model schema) {
        StmtIterator it = schema.listStatements((Resource)ANY, RDFS.subClassOf, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!s.getSubject().isURIResource() || !s.getObject().isURIResource()) continue;
            result2.add(s);
        }
    }

    public static void addSubClassClosure(Model m) {
        Set<Resource> roots = ModelExpansion.selectRootClasses(m, ModelExpansion.findClassesBySubClassOf(m));
        for (Resource root2 : roots) {
            ModelExpansion.addSuperClasses(m, root2);
        }
    }

    private static void addSuperClasses(Model m, Resource type) {
        ModelExpansion.addSuperClasses(m, new LinkedSeq(type));
    }

    private static void addSuperClasses(Model m, LinkedSeq parents) {
        Model toAdd = ModelFactory.createDefaultModel();
        ModelExpansion.addSuperClasses(m, parents, toAdd);
        m.add(toAdd);
    }

    private static void addSuperClasses(Model m, LinkedSeq parents, Model toAdd) {
        Resource type = parents.item;
        StmtIterator it = m.listStatements(null, RDFS.subClassOf, type);
        while (it.hasNext()) {
            Resource t = it.nextStatement().getSubject();
            LinkedSeq scan = parents.rest;
            while (scan != null) {
                toAdd.add(t, RDFS.subClassOf, scan.item);
                scan = scan.rest;
            }
            ModelExpansion.addSuperClasses(m, parents.push(t), toAdd);
        }
    }

    private static Set<Resource> selectRootClasses(Model m, Set<RDFNode> classes) {
        HashSet<Resource> roots = new HashSet<Resource>();
        for (RDFNode aClass : classes) {
            Resource type = (Resource)aClass;
            if (m.contains(type, RDFS.subClassOf, (RDFNode)null)) continue;
            roots.add(type);
        }
        return roots;
    }

    private static Set<RDFNode> findClassesBySubClassOf(Model m) {
        HashSet<RDFNode> classes = new HashSet<RDFNode>();
        StmtIterator it = m.listStatements(null, RDFS.subClassOf, (RDFNode)null);
        while (it.hasNext()) {
            ModelExpansion.addClasses(classes, it.nextStatement());
        }
        return classes;
    }

    private static void addClasses(Set<RDFNode> classes, Statement xSubClassOfY) {
        classes.add(xSubClassOfY.getSubject());
        classes.add(xSubClassOfY.getObject());
    }

    protected static void addDomainTypes(Model result2, Model schema) {
        StmtIterator it = schema.listStatements((Resource)ANY, RDFS.domain, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Property property = s.getSubject().as(Property.class);
            RDFNode type = s.getObject();
            StmtIterator x = result2.listStatements((Resource)ANY, property, ANY);
            while (x.hasNext()) {
                Statement t = x.nextStatement();
                result2.add(t.getSubject(), RDF.type, type);
            }
        }
    }

    protected static void addRangeTypes(Model result2, Model schema) {
        Model toAdd = ModelFactory.createDefaultModel();
        StmtIterator it = schema.listStatements((Resource)ANY, RDFS.range, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            RDFNode type = s.getObject();
            Property property = s.getSubject().as(Property.class);
            StmtIterator x = result2.listStatements((Resource)ANY, property, ANY);
            while (x.hasNext()) {
                RDFNode ob = x.nextStatement().getObject();
                if (!ob.isResource()) continue;
                toAdd.add((Resource)ob, RDF.type, type);
            }
        }
        result2.add(toAdd);
    }

    protected static void addSupertypes(Model result2) {
        Model temp = ModelFactory.createDefaultModel();
        StmtIterator it = result2.listStatements((Resource)ANY, RDF.type, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Resource c = AssemblerHelp.getResource(s);
            StmtIterator subclasses = result2.listStatements(c, RDFS.subClassOf, ANY);
            while (subclasses.hasNext()) {
                RDFNode type = subclasses.nextStatement().getObject();
                temp.add(s.getSubject(), RDF.type, type);
            }
        }
        result2.add(temp);
    }

    private static void addIntersections(Model result2, Model schema) {
        StmtIterator it = schema.listStatements((Resource)ANY, OWL.intersectionOf, ANY);
        while (it.hasNext()) {
            ModelExpansion.addIntersections(result2, schema, it.nextStatement());
        }
    }

    private static void addIntersections(Model result2, Model schema, Statement s) {
        Resource type = s.getSubject();
        List<RDFNode> types = ModelExpansion.asJavaList(AssemblerHelp.getResource(s));
        Set<Resource> candidates = ModelExpansion.subjectSet(result2, ANY, RDF.type, types.get(0));
        for (int i = 1; i < types.size(); ++i) {
            ModelExpansion.removeElementsWithoutType(candidates, (Resource)types.get(i));
        }
        ModelExpansion.addTypeToAll(type, candidates);
    }

    private static void addTypeToAll(Resource type, Set<Resource> candidates) {
        List<Resource> types = ModelExpansion.equivalentTypes(type);
        Iterator<Resource> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            Resource element;
            Resource resource = element = iterator.next();
            for (Resource type1 : types) {
                resource.addProperty(RDF.type, type1);
            }
        }
    }

    private static List<Resource> equivalentTypes(Resource type) {
        ArrayList<Resource> types = new ArrayList<Resource>();
        types.add(type);
        StmtIterator it = type.getModel().listStatements((Resource)ANY, OWL.equivalentClass, type);
        while (it.hasNext()) {
            types.add(it.nextStatement().getSubject());
        }
        return types;
    }

    private static void removeElementsWithoutType(Set<Resource> candidates, Resource type) {
        Iterator<Resource> it = candidates.iterator();
        while (it.hasNext()) {
            Resource candidate = it.next();
            if (candidate.hasProperty(RDF.type, type)) continue;
            it.remove();
        }
    }

    private static Set<Resource> subjectSet(Model result2, Resource S, Property P2, RDFNode O) {
        return result2.listStatements(S, P2, O).mapWith(Statement::getSubject).toSet();
    }

    private static List<RDFNode> asJavaList(Resource resource) {
        return resource.as(RDFList.class).asJavaList();
    }

    protected static class LinkedSeq {
        final Resource item;
        final LinkedSeq rest;

        LinkedSeq(Resource item) {
            this(item, null);
        }

        LinkedSeq(Resource item, LinkedSeq rest) {
            this.item = item;
            this.rest = rest;
        }

        LinkedSeq push(Resource item) {
            return new LinkedSeq(item, this);
        }

        public String toString() {
            StringBuffer result2 = new StringBuffer("[");
            LinkedSeq scan = this;
            while (scan != null) {
                result2.append(scan.item);
                scan = scan.rest;
                result2.append(" ");
            }
            return result2.append("]").toString();
        }
    }
}

