/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.PrefixMapping);
        return PrefixMappingAssembler.getPrefixes(a, root2, PrefixMapping.Factory.create());
    }

    public static PrefixMapping getPrefixes(Assembler a, Resource root2, PrefixMapping result2) {
        PrefixMappingAssembler.setSimplePrefixes(root2, result2);
        PrefixMappingAssembler.includePrefixesFor(a, root2, result2, JA.includes);
        PrefixMappingAssembler.includePrefixesFor(a, root2, result2, JA.prefixMapping);
        return result2;
    }

    private static void includePrefixesFor(Assembler a, Resource root2, PrefixMapping result2, Property includeUsing) {
        StmtIterator it = root2.listProperties(includeUsing);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            PrefixMapping sub = (PrefixMapping)a.open(PrefixMappingAssembler.getResource(s));
            result2.setNsPrefixes(sub);
        }
    }

    private static void setSimplePrefixes(Resource root2, PrefixMapping result2) {
        if (root2.hasProperty(JA.prefix)) {
            Literal prefix = PrefixMappingAssembler.getUniqueLiteral(root2, JA.prefix);
            Literal namespace2 = PrefixMappingAssembler.getUniqueLiteral(root2, JA.namespace);
            result2.setNsPrefix(prefix.getLexicalForm(), namespace2.getLexicalForm());
        }
    }
}

