/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.util.iterator.ClosableIterator;

public class BBRuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected BackwardRuleInfGraphI graph;

    public BBRuleContext(BackwardRuleInfGraphI graph) {
        this.graph = graph;
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        ClosableIterator<Triple> i = this.find(s, p, o);
        boolean result2 = i.hasNext();
        i.close();
        return result2;
    }

    @Override
    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    @Override
    public ClosableIterator<Triple> find(Node s, Node p, Node o) {
        return this.graph.findDataMatches(new TriplePattern(s, p, o));
    }

    @Override
    public BindingEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(BindingEnvironment env) {
        this.env = env;
    }

    @Override
    public InfGraph getGraph() {
        return this.graph;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    @Override
    public void silentAdd(Triple t) {
        this.graph.silentAdd(t);
    }

    @Override
    public void add(Triple t) {
        this.graph.silentAdd(t);
    }

    @Override
    public void remove(Triple t) {
        this.graph.delete(t);
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.graph.getTemp(instance, prop, pclass);
    }
}

