/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.transitiveReasoner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import org.apache.jena.shared.BrokenException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.WrappedIterator;

class GraphNode {
    protected Node rdfNode;
    protected Set<GraphNode> succ = new HashSet<GraphNode>();
    protected Set<GraphNode> pred = new HashSet<GraphNode>();
    protected Set<GraphNode> succClosed = new HashSet<GraphNode>();
    protected List<Triple> succClosedTriples;
    private Siblings siblings = new Siblings();

    private Set<GraphNode> siblings() {
        return this.siblings.members();
    }

    private void addSiblings(Set<GraphNode> target, GraphNode m) {
        m.siblings.addInto(target, m);
    }

    public GraphNode leadNode() {
        return this.siblings.leadNode(this);
    }

    public Iterator<GraphNode> siblingIterator() {
        return this.siblings.siblingIterator();
    }

    public Iterator<GraphNode> concatenateSiblings(Iterator<GraphNode> base) {
        return WrappedIterator.create(base).andThen(this.siblings.siblingIterator());
    }

    private void becomeSubordinateOf(GraphNode leader) {
        this.siblings = new Subordinate(leader);
    }

    private void becomeLeaderOf(Set<GraphNode> newSiblings) {
        this.siblings = new Leader(newSiblings);
    }

    public String dump() {
        return this.rdfNode.getLocalName() + this.siblings.dump() + " succ=" + GraphNode.dumpSet(this.succ) + ", succClose=" + GraphNode.dumpSet(this.succClosed) + ", pred=" + GraphNode.dumpSet(this.pred);
    }

    public GraphNode(Node node) {
        this.rdfNode = node;
    }

    public boolean pathTo(GraphNode A) {
        if (this == A) {
            return true;
        }
        return this.succClosed.contains(A);
    }

    public boolean directPathTo(GraphNode A) {
        if (this == A) {
            return true;
        }
        return this.succ.contains(A);
    }

    public <Alpha, Beta> void visitPredecessors(TransitiveGraphCache.Visitor<Alpha, Beta> visitor, Alpha arg1, Beta arg2) {
        List<GraphNode> kill = visitor.visit(this, null, arg1, arg2);
        if (kill != null) {
            this.pred.removeAll(kill);
        }
        this.doVisitPredecessors(visitor, arg1, arg2, new HashSet<GraphNode>());
    }

    private <Alpha, Beta> void doVisitPredecessors(TransitiveGraphCache.Visitor<Alpha, Beta> visitor, Alpha arg1, Beta arg2, Set<GraphNode> seen) {
        if (seen.add(this)) {
            ArrayList<GraphNode> allKill = null;
            for (GraphNode pred : this.pred) {
                List<GraphNode> kill = visitor.visit(pred, this, arg1, arg2);
                if (kill == null) continue;
                if (allKill == null) {
                    allKill = new ArrayList<GraphNode>();
                }
                allKill.addAll(kill);
            }
            if (allKill != null) {
                this.pred.removeAll(allKill);
            }
            for (GraphNode pred : this.pred) {
                pred.doVisitPredecessors(visitor, arg1, arg2, seen);
            }
        }
    }

    public Iterator<GraphNode> iteratorOverSuccessors() {
        return this.succClosed.iterator();
    }

    public void assertLinkTo(GraphNode target) {
        if (this == target) {
            return;
        }
        this.succ.add(target);
        target.pred.add(this);
        this.clearTripleCache();
    }

    public void retractLinkTo(GraphNode target) {
        if (this == target) {
            return;
        }
        this.succ.remove(target);
        target.pred.remove(this);
        this.clearTripleCache();
    }

    public void assertIndirectLinkTo(GraphNode target) {
        this.succClosed.add(target);
        this.clearTripleCache();
    }

    public void clearTripleCache() {
        this.succClosedTriples = null;
    }

    public void propagateAdd(GraphNode target) {
        HashSet<GraphNode> sc = new HashSet<GraphNode>(target.succClosed);
        sc.add(target);
        this.visitPredecessors(new TransitiveGraphCache.Visitor<Set<GraphNode>, GraphNode>(){

            @Override
            public List<GraphNode> visit(GraphNode node, GraphNode processing, Set<GraphNode> sc, GraphNode target) {
                node.succClosed.addAll(sc);
                ArrayList<GraphNode> kill = null;
                Iterator<GraphNode> i = node.succ.iterator();
                while (i.hasNext()) {
                    GraphNode s = i.next();
                    if (!sc.contains(s)) continue;
                    i.remove();
                    if (s == processing) {
                        if (kill == null) {
                            kill = new ArrayList<GraphNode>();
                        }
                        kill.add(node);
                        continue;
                    }
                    s.pred.remove(node);
                }
                return kill;
            }
        }, sc, target);
    }

    public void propagateSCC() {
        HashSet<GraphNode> visited = new HashSet<GraphNode>();
        visited.add(this);
        this.doVisitPredecessors(new TransitiveGraphCache.Visitor<Set<GraphNode>, Object>(){

            @Override
            public List<GraphNode> visit(GraphNode node, GraphNode processing, Set<GraphNode> sc, Object ignored) {
                node.succClosed.addAll(sc);
                ArrayList<GraphNode> kill = null;
                Iterator<GraphNode> i = node.succ.iterator();
                while (i.hasNext()) {
                    GraphNode s = i.next();
                    if (!sc.contains(s)) continue;
                    i.remove();
                    if (s == processing) {
                        if (kill == null) {
                            kill = new ArrayList<GraphNode>();
                        }
                        kill.add(node);
                        continue;
                    }
                    s.pred.remove(node);
                }
                return kill;
            }
        }, this.succClosed, null, visited);
    }

    public void makeLeadNodeFor(Set<GraphNode> members) {
        HashSet<GraphNode> newSucc = new HashSet<GraphNode>();
        HashSet<GraphNode> newSuccClosed = new HashSet<GraphNode>();
        for (GraphNode n : members) {
            newSucc.addAll(n.succ);
            newSuccClosed.addAll(n.succClosed);
        }
        newSucc.removeAll(members);
        newSuccClosed.removeAll(members);
        this.succ = newSucc;
        this.succClosed = newSuccClosed;
        for (GraphNode n : this.succ) {
            n.pred.removeAll(members);
            n.pred.add(this);
        }
        HashSet<GraphNode> done = new HashSet<GraphNode>();
        HashSet<GraphNode> newAliases = new HashSet<GraphNode>();
        for (GraphNode member : members) {
            this.addSiblings(newAliases, member);
        }
        this.becomeLeaderOf(newAliases);
        for (GraphNode n : members) {
            if (n == this) continue;
            this.pred.addAll(n.pred);
            n.relocateAllRefTo(this, done);
            n.becomeSubordinateOf(this);
        }
        this.pred.removeAll(members);
    }

    private void relocateAllRefTo(GraphNode lead, Set<GraphNode> done) {
        this.visitPredecessors(new TransitiveGraphCache.Visitor<Set<GraphNode>, GraphNode>(){

            @Override
            public List<GraphNode> visit(GraphNode node, GraphNode processing, Set<GraphNode> done, GraphNode leadIn) {
                if (done.add(node)) {
                    Set members = leadIn.siblings();
                    int before = node.succ.size();
                    node.succ.removeAll(members);
                    node.succClosed.removeAll(members);
                    node.succClosed.add(leadIn);
                    if (node.succ.size() != before) {
                        node.succ.add(leadIn);
                    }
                }
                return null;
            }
        }, done, lead);
    }

    public ExtendedIterator<Triple> listTriples(boolean closed, TransitiveGraphCache tgc) {
        if (tgc.cacheTriples) {
            return WrappedIterator.create(this.leadNode().triplesForSuccessors(this.rdfNode, closed, tgc).iterator());
        }
        return WrappedIterator.create(this.leadNode().triplesForSuccessors(this.rdfNode, closed, tgc).iterator());
    }

    private List<Triple> triplesForSuccessors(Node base, boolean closed, TransitiveGraphCache tgc) {
        Set<GraphNode> successors = closed ? this.succClosed : this.succ;
        ArrayList<Triple> result2 = new ArrayList<Triple>(successors.size() + 10);
        result2.add(new Triple(base, tgc.closedPredicate, base));
        for (GraphNode s : successors) {
            result2.add(new Triple(base, tgc.closedPredicate, s.rdfNode));
            s.siblings.addSuccessors(base, tgc, result2);
        }
        this.siblings.addSuccessors(base, tgc, result2);
        return result2;
    }

    public ExtendedIterator<Triple> listPredecessorTriples(boolean closed, TransitiveGraphCache tgc) {
        return new TransitiveGraphCache.GraphWalker(this.leadNode(), this.rdfNode, closed, tgc.closedPredicate);
    }

    public String toString() {
        return "[" + this.rdfNode.getLocalName() + "]";
    }

    private static String dumpSet(Set<GraphNode> s) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean started = false;
        for (GraphNode value : s) {
            if (started) {
                sb.append(", ");
            } else {
                started = true;
            }
            sb.append(value.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    static class Subordinate
    extends Siblings {
        final GraphNode leader;

        Subordinate(GraphNode n) {
            this.leader = n;
        }

        @Override
        Set<GraphNode> members() {
            throw new BrokenException("cannot ask for components of a raw GraphNode");
        }

        @Override
        GraphNode leadNode(GraphNode unlessSpecified) {
            return this.leader.leadNode();
        }

        @Override
        String dump() {
            return " leader=" + this.leader + ", ";
        }
    }

    static class Leader
    extends Siblings {
        final Set<GraphNode> components;

        Leader(Set<GraphNode> components) {
            this.components = components;
        }

        @Override
        Set<GraphNode> members() {
            return this.components;
        }

        @Override
        void addInto(Set<GraphNode> nodes, GraphNode ignored) {
            nodes.addAll(this.components);
        }

        @Override
        void addSuccessors(Node base, TransitiveGraphCache tgc, ArrayList<Triple> result2) {
            for (GraphNode component : this.components) {
                result2.add(new Triple(base, tgc.closedPredicate, component.rdfNode));
            }
        }

        @Override
        Iterator<GraphNode> siblingIterator() {
            return this.components.iterator();
        }

        @Override
        String dump() {
            return " SCC=" + GraphNode.dumpSet(this.components) + ", ";
        }
    }

    static class Siblings {
        static final NullIterator<GraphNode> noMembers = NullIterator.instance();

        Siblings() {
        }

        Set<GraphNode> members() {
            throw new BrokenException("cannot ask for components of a raw GraphNode");
        }

        void addInto(Set<GraphNode> nodes, GraphNode m) {
            nodes.add(m);
        }

        void addSuccessors(Node base, TransitiveGraphCache tgc, ArrayList<Triple> result2) {
        }

        Iterator<GraphNode> siblingIterator() {
            return noMembers;
        }

        GraphNode leadNode(GraphNode unlessSpecified) {
            return unlessSpecified;
        }

        String dump() {
            return "";
        }
    }
}

