/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class RDFWriterRIOT
implements RDFWriter {
    private final String basename;
    private final String jenaName;
    private Context context = new Context();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private WriterGraphRIOT writer;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFWriterRIOT(String jenaName) {
        this.basename = "org.apache.jena.riot.writer." + jenaName.toLowerCase(Locale.ROOT);
        this.jenaName = jenaName;
        this.context.put(SysRIOT.sysRdfWriterProperties, this.properties);
    }

    private WriterGraphRIOT writer() {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.jenaName == null) {
            throw new IllegalArgumentException("Jena writer name is null");
        }
        RDFFormat format = RDFWriterRegistry.getFormatForJenaWriter(this.jenaName);
        if (format != null) {
            return RDFDataMgr.createGraphWriter(format);
        }
        Lang lang = RDFLanguages.nameToLang(this.jenaName);
        if (lang != null) {
            return RDFDataMgr.createGraphWriter(lang);
        }
        throw new RiotException("No graph writer for '" + this.jenaName + "'");
    }

    @Override
    public void write(Model model, Writer out, String base) {
        if (base != null && base.equals("")) {
            base = null;
        }
        Graph graph = model.getGraph();
        this.writer().write(out, graph, RiotLib.prefixMap(graph), base, this.context);
    }

    @Override
    public void write(Model model, OutputStream out, String base) {
        if (base != null && base.equals("")) {
            base = null;
        }
        Graph graph = model.getGraph();
        this.writer().write(out, graph, RiotLib.prefixMap(graph), base, this.context);
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        Symbol sym = Symbol.create(this.basename + "#" + propName);
        Object oldObj = this.context.get(sym);
        this.context.set(sym, propValue);
        this.properties.put(propName, propValue);
        return oldObj;
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }
}

