/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.NodeValue;

public abstract class ExprDigest
extends ExprFunction1 {
    private final String digestName;
    private MessageDigest digestCache;
    NodeValue lastSeen = null;
    NodeValue lastCalc = null;

    public ExprDigest(Expr expr, String symbol, String digestName) {
        super(expr, symbol);
        this.digestName = digestName;
        try {
            this.digestCache = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new ARQInternalErrorException("Digest not provided in this Java system: " + digestName);
        }
    }

    private MessageDigest getDigest() {
        if (this.digestCache != null) {
            MessageDigest digest2 = null;
            try {
                digest2 = (MessageDigest)this.digestCache.clone();
                return digest2;
            }
            catch (CloneNotSupportedException ex) {
                this.digestCache = null;
            }
        }
        return this.createDigest();
    }

    private MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance(this.digestName);
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException(ex2);
        }
    }

    @Override
    public NodeValue eval(NodeValue v) {
        if (this.lastSeen != null && this.lastSeen.equals(v)) {
            return this.lastCalc;
        }
        Node n = v.asNode();
        if (!n.isLiteral()) {
            throw new ExprEvalException("Not a literal: " + v);
        }
        if (n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("")) {
            throw new ExprEvalException("Can't make a digest of an RDF term with a language tag");
        }
        if (n.getLiteralDatatype() != null && !XSDDatatype.XSDstring.equals(n.getLiteralDatatype())) {
            throw new ExprEvalException("Not a simple literal nor an XSD string");
        }
        try {
            MessageDigest digest = this.getDigest();
            String x = n.getLiteralLexicalForm();
            byte[] b = x.getBytes(StandardCharsets.UTF_8);
            byte[] d = digest.digest(b);
            String y = Bytes.asHexLC(d);
            NodeValue result2 = NodeValue.makeString(y);
            this.lastSeen = v;
            this.lastCalc = result2;
            return result2;
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException(ex2);
        }
    }
}

