/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessFunction<I, T extends TBase> {
    private final String methodName;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessFunction.class.getName());

    public ProcessFunction(String methodName) {
        this.methodName = methodName;
    }

    public final void process(int seqid, TProtocol iprot, TProtocol oprot, I iface) throws TException {
        T args = this.getEmptyArgsInstance();
        try {
            args.read(iprot);
        }
        catch (TProtocolException e2) {
            iprot.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e2.getMessage());
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            return;
        }
        iprot.readMessageEnd();
        TBase result2 = null;
        try {
            result2 = this.getResult(iface, args);
        }
        catch (TException tex) {
            LOGGER.error("Internal error processing " + this.getMethodName(), tex);
            TApplicationException x = new TApplicationException(6, "Internal error processing " + this.getMethodName());
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            return;
        }
        if (!this.isOneway()) {
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 2, seqid));
            result2.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
        }
    }

    protected abstract boolean isOneway();

    public abstract TBase getResult(I var1, T var2) throws TException;

    public abstract T getEmptyArgsInstance();

    public String getMethodName() {
        return this.methodName;
    }
}

