/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import javax.script.ScriptException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.topbraid.shacl.arq.SHACLARQFunction;
import org.topbraid.shacl.js.JSGraph;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.js.model.JSFactory;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.model.SHJSFunction;
import org.topbraid.spin.util.ExceptionUtil;
import org.topbraid.spin.util.JenaDatatypes;

public class SHACLJSARQFunction
extends SHACLARQFunction {
    private String functionName;

    public SHACLJSARQFunction(SHJSFunction shaclFunction) {
        super(shaclFunction);
        this.functionName = shaclFunction.getFunctionName();
        this.addParameters(shaclFunction);
    }

    @Override
    public NodeValue executeBody(Dataset dataset, Model dataModel, QuerySolution bindings) {
        if (this.functionName == null) {
            throw new IllegalArgumentException("Missing JavaScript function name of " + this.getSHACLFunction().getURI());
        }
        boolean nested = SHACLScriptEngineManager.begin();
        JSScriptEngine engine = SHACLScriptEngineManager.getCurrentEngine();
        SHJSExecutable as = this.getSHACLFunction().as(SHJSExecutable.class);
        JSGraph dataJSGraph = new JSGraph(dataModel.getGraph(), engine);
        try {
            engine.executeLibraries(as);
            engine.put("$data", dataJSGraph);
            Object result2 = engine.invokeFunction(this.functionName, bindings);
            if (result2 != null) {
                Node node = JSFactory.getNode(result2);
                if (node != null) {
                    NodeValue nodeValue = NodeValue.makeNode(node);
                    return nodeValue;
                }
                if (result2 instanceof String) {
                    NodeValue nodeValue = NodeValue.makeNode(NodeFactory.createLiteral((String)result2));
                    return nodeValue;
                }
                if (result2 instanceof Long) {
                    NodeValue nodeValue = NodeValue.makeNode(JenaDatatypes.createInteger(((Long)result2).intValue()).asNode());
                    return nodeValue;
                }
                if (result2 instanceof Integer) {
                    NodeValue nodeValue = NodeValue.makeNode(JenaDatatypes.createInteger((Integer)result2).asNode());
                    return nodeValue;
                }
                if (result2 instanceof Double) {
                    NodeValue nodeValue = NodeValue.makeDecimal((Double)result2);
                    return nodeValue;
                }
                if (result2 instanceof Boolean) {
                    NodeValue nodeValue = NodeValue.booleanReturn((Boolean)result2);
                    return nodeValue;
                }
            }
        }
        catch (ScriptException ex) {
            ExceptionUtil.throwUnchecked(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExprEvalException(ex);
        }
        finally {
            dataJSGraph.close();
            SHACLScriptEngineManager.end(nested);
        }
        throw new ExprEvalException();
    }

    @Override
    protected String getQueryString() {
        return ((SHJSFunction)this.getSHACLFunction()).getFunctionName();
    }
}

