/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.util.JenaUtil;

public class ShapesGraph {
    private Predicate<Constraint> constraintFilter;
    private Map<Property, SHConstraintComponent> parametersMap;
    private List<Shape> rootShapes;
    private Predicate<SHShape> shapeFilter;
    private Map<Node, Shape> shapesMap = new HashMap<Node, Shape>();
    private Model shapesModel;

    public ShapesGraph(Model shapesModel) {
        this.shapesModel = shapesModel;
    }

    private void computeParametersMap() {
        if (this.parametersMap == null) {
            this.parametersMap = new HashMap<Property, SHConstraintComponent>();
            for (Resource cc : JenaUtil.getAllInstances(SH.ConstraintComponent.inModel(this.shapesModel))) {
                SHConstraintComponent component = SHFactory.asConstraintComponent(cc);
                for (SHParameter param2 : component.getParameters()) {
                    if (param2.isOptional()) continue;
                    this.parametersMap.put(param2.getPredicate(), component);
                }
            }
        }
    }

    public SHConstraintComponent getComponentWithParameter(Property parameter) {
        this.computeParametersMap();
        return this.parametersMap.get(parameter);
    }

    public List<Shape> getRootShapes() {
        if (this.rootShapes == null) {
            HashSet<Object> candidates = new HashSet<Object>();
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.target).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetClass).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetNode).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetObjectsOf).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetSubjectsOf).toList());
            for (Resource resource : JenaUtil.getAllInstances(this.shapesModel.getResource(SH.NodeShape.getURI()))) {
                if (!JenaUtil.hasIndirectType(resource, RDFS.Class)) continue;
                candidates.add(resource);
            }
            for (Resource resource : JenaUtil.getAllInstances(this.shapesModel.getResource(SH.PropertyShape.getURI()))) {
                if (!JenaUtil.hasIndirectType(resource, RDFS.Class)) continue;
                candidates.add(resource);
            }
            this.rootShapes = new LinkedList<Shape>();
            for (Resource resource : candidates) {
                SHShape shape = SHFactory.asShape(resource);
                if (this.shapeFilter != null && !this.shapeFilter.test(shape)) continue;
                this.rootShapes.add(this.getShape(shape.asNode()));
            }
        }
        return this.rootShapes;
    }

    public Shape getShape(Node node) {
        Shape shape = this.shapesMap.get(node);
        if (shape == null) {
            shape = new Shape(this, SHFactory.asShape(this.shapesModel.asRDFNode(node)));
            this.shapesMap.put(node, shape);
        }
        return shape;
    }

    public boolean isIgnoredConstraint(Constraint constraint) {
        return this.constraintFilter != null && !this.constraintFilter.test(constraint);
    }

    public boolean isIgnored(Node shapeNode) {
        if (this.shapeFilter == null) {
            return false;
        }
        SHShape shape = SHFactory.asShape(this.shapesModel.asRDFNode(shapeNode));
        return !this.shapeFilter.test(shape);
    }

    public void setConstraintFilter(Predicate<Constraint> value) {
        this.constraintFilter = value;
    }

    public void setShapeFilter(Predicate<SHShape> value) {
        this.shapeFilter = value;
    }
}

