/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizable;
import org.topbraid.shacl.model.SHParameterizableInstance;
import org.topbraid.shacl.model.impl.SHResourceImpl;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.spin.util.JenaUtil;

public class SHParameterizableInstanceImpl
extends SHResourceImpl
implements SHParameterizableInstance {
    public SHParameterizableInstanceImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public SHParameterizable getParameterizable() {
        Resource type = JenaUtil.getType(this);
        if (type != null) {
            return SHFactory.asParameterizable(type);
        }
        type = SHACLUtil.getResourceDefaultType(this);
        if (type != null) {
            return SHFactory.asParameterizable(type);
        }
        return null;
    }

    @Override
    public Map<String, RDFNode> getParameterMapByVarNames() {
        HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
        SHParameterizable template = this.getParameterizable();
        if (template != null) {
            for (SHParameter arg : template.getParameters()) {
                Property argProperty = arg.getPredicate();
                if (argProperty == null) continue;
                String varName = arg.getVarName();
                Statement valueS = this.getProperty(argProperty);
                if (valueS == null) continue;
                map.put(varName, valueS.getObject());
            }
        }
        return map;
    }

    @Override
    public void addBindings(QuerySolutionMap bindings) {
        for (SHParameter arg : this.getParameterizable().getParameters()) {
            Statement s = this.getProperty(arg.getPredicate());
            if (s == null) continue;
            bindings.add(arg.getVarName(), s.getObject());
        }
    }
}

