/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.net.URI;
import java.util.UUID;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.arq.SHACLFunctions;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.util.SHACLSystemModel;
import org.topbraid.shacl.vocabulary.TOSH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.util.JenaUtil;

public class RuleUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model executeRules(Model dataModel, Model shapesModel, Model inferencesModel, ProgressMonitor monitor) {
        if (!shapesModel.contains(TOSH.hasShape, RDF.type, (RDFNode)null)) {
            Model unionModel = SHACLSystemModel.getSHACLModel();
            MultiUnion unionGraph = new MultiUnion(new Graph[]{unionModel.getGraph(), shapesModel.getGraph()});
            shapesModel = ModelFactory.createModelForGraph(unionGraph);
        }
        SHACLFunctions.registerFunctions(shapesModel);
        if (inferencesModel == null) {
            inferencesModel = JenaUtil.createDefaultModel();
            MultiUnion unionGraph = new MultiUnion(new Graph[]{dataModel.getGraph(), inferencesModel.getGraph()});
            dataModel = ModelFactory.createModelForGraph(unionGraph);
        }
        URI shapesGraphURI = URI.create("urn:x-shacl-shapes-graph:" + UUID.randomUUID().toString());
        Dataset dataset = ARQFactory.get().getDataset(dataModel);
        dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
        ShapesGraph shapesGraph = new ShapesGraph(shapesModel);
        RuleEngine engine = new RuleEngine(dataset, shapesGraphURI, shapesGraph, inferencesModel);
        engine.setProgressMonitor(monitor);
        boolean nested = SHACLScriptEngineManager.begin();
        try {
            engine.executeAll();
        }
        catch (InterruptedException ex) {
            Model model = null;
            return model;
        }
        finally {
            SHACLScriptEngineManager.end(nested);
        }
        return inferencesModel;
    }
}

