/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.expr.AppendContext;
import org.topbraid.shacl.expr.ComplexNodeExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionFactory;
import org.topbraid.shacl.rules.Rule;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.util.JenaUtil;

class TripleRule
extends Rule {
    private static boolean SPARQL_MODE = false;
    private NodeExpression object;
    private NodeExpression predicate;
    private NodeExpression subject;

    TripleRule(Resource resource) {
        super(resource);
        this.object = this.createNodeExpression(resource, SH.object);
        this.predicate = this.createNodeExpression(resource, SH.predicate);
        this.subject = this.createNodeExpression(resource, SH.subject);
    }

    private NodeExpression createNodeExpression(Resource resource, Property predicate) {
        Statement s = resource.getProperty(predicate);
        if (s == null) {
            throw new IllegalArgumentException("Triple rule without " + predicate.getLocalName());
        }
        return NodeExpressionFactory.get().create(s.getObject());
    }

    @Override
    public void execute(RuleEngine ruleEngine, List<RDFNode> focusNodes, Shape shape) {
        if (SPARQL_MODE) {
            this.executeSPARQL(ruleEngine, focusNodes, shape);
        } else {
            ProgressMonitor monitor = ruleEngine.getProgressMonitor();
            for (RDFNode focusNode : focusNodes) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                List<RDFNode> subjects = this.subject.eval(focusNode, ruleEngine);
                List<RDFNode> predicates = this.predicate.eval(focusNode, ruleEngine);
                List<RDFNode> objects = this.object.eval(focusNode, ruleEngine);
                for (RDFNode subjectR : subjects) {
                    if (!subjectR.isResource()) continue;
                    Resource subject = (Resource)subjectR;
                    for (RDFNode predicateR : predicates) {
                        if (!predicateR.isURIResource()) continue;
                        Property predicate = JenaUtil.asProperty((Resource)predicateR);
                        for (RDFNode object : objects) {
                            ruleEngine.infer(Triple.create(subject.asNode(), predicate.asNode(), object.asNode()), this, shape);
                        }
                    }
                }
            }
        }
    }

    private void executeSPARQL(RuleEngine ruleEngine, List<RDFNode> focusNodes, Shape shape) {
        String queryString = this.getSPARQL();
        Query query = ARQFactory.get().createQuery(ruleEngine.getDataset().getDefaultModel(), queryString);
        QuerySolutionMap binding = new QuerySolutionMap();
        for (RDFNode focusNode : focusNodes) {
            Model c;
            binding.add(SH.thisVar.getVarName(), focusNode);
            try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, ruleEngine.getDataset(), (QuerySolution)binding);){
                c = qexec.execConstruct();
            }
            for (Triple triple : c.getGraph().find(Node.ANY, Node.ANY, Node.ANY).toList()) {
                ruleEngine.infer(triple, this, shape);
            }
        }
    }

    private String getSPARQL() {
        StringBuffer sb = new StringBuffer();
        AppendContext context = new AppendContext(sb);
        sb.append("\nCONSTRUCT {\n");
        sb.append("    ");
        if (this.subject instanceof ComplexNodeExpression) {
            sb.append("?subject");
        } else {
            sb.append(this.subject);
        }
        sb.append(" ");
        if (this.predicate instanceof ComplexNodeExpression) {
            sb.append("?predicate");
        } else {
            sb.append(this.predicate);
        }
        sb.append(" ");
        if (this.object instanceof ComplexNodeExpression) {
            sb.append("?object");
        } else {
            sb.append(this.object);
        }
        sb.append(" .\n}\nWHERE {\n");
        context.increaseIndent();
        if (this.subject instanceof ComplexNodeExpression) {
            ((ComplexNodeExpression)this.subject).appendLabel(context, "subject");
        }
        if (this.predicate instanceof ComplexNodeExpression) {
            ((ComplexNodeExpression)this.predicate).appendLabel(context, "predicate");
        }
        if (this.object instanceof ComplexNodeExpression) {
            ((ComplexNodeExpression)this.object).appendLabel(context, "object");
        }
        context.decreaseIndent();
        sb.append("}");
        String label = sb.toString();
        return label;
    }

    public String toString() {
        String label = this.getLabel();
        if (label == null) {
            label = this.getSPARQL();
        }
        return this.getLabelStart("Triple") + label;
    }
}

