/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.testcases.context.JSPreferredTestCaseContext;
import org.topbraid.shacl.testcases.context.SPARQLPreferredTestCaseContext;
import org.topbraid.shacl.testcases.context.TestCaseContext;
import org.topbraid.shacl.testcases.context.TestCaseContextFactory;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.SPINThreadFunctionRegistry;
import org.topbraid.spin.arq.SPINThreadFunctions;
import org.topbraid.spin.util.JenaUtil;

public class FunctionTestCaseType
implements TestCaseType {
    private static List<TestCaseContextFactory> contextFactories = new LinkedList<TestCaseContextFactory>();

    public static void registerContextFactory(TestCaseContextFactory factory) {
        contextFactories.add(factory);
    }

    @Override
    public Collection<TestCase> getTestCases(Model model, Resource graph) {
        LinkedList<TestCase> results = new LinkedList<TestCase>();
        for (Resource resource : JenaUtil.getAllInstances(model.getResource(DASH.FunctionTestCase.getURI()))) {
            results.add(new FunctionTestCase(graph, resource));
        }
        return results;
    }

    static {
        FunctionTestCaseType.registerContextFactory(SPARQLPreferredTestCaseContext.getTestCaseContextFactory());
        FunctionTestCaseType.registerContextFactory(JSPreferredTestCaseContext.getTestCaseContextFactory());
    }

    private static class FunctionTestCase
    extends TestCase {
        FunctionTestCase(Resource graph, Resource resource) {
            super(graph, resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run(Model results) {
            Resource testCase = this.getResource();
            FunctionRegistry oldFR = FunctionRegistry.get();
            SPINThreadFunctionRegistry threadFR = new SPINThreadFunctionRegistry(oldFR);
            FunctionRegistry.set(ARQ.getContext(), threadFR);
            SPINThreadFunctions old = SPINThreadFunctionRegistry.register(testCase.getModel());
            try {
                for (TestCaseContextFactory contextFactory : contextFactories) {
                    TestCaseContext context = contextFactory.createContext();
                    String expression = JenaUtil.getStringProperty(testCase, DASH.expression);
                    Statement expectedResultS = testCase.getProperty(DASH.expectedResult);
                    String queryString = "SELECT (" + expression + " AS ?result) WHERE {}";
                    Query query = ARQFactory.get().createQuery(testCase.getModel(), queryString);
                    context.setUpTestContext();
                    try {
                        QueryExecution qexec = ARQFactory.get().createQueryExecution(query, testCase.getModel());
                        Throwable throwable = null;
                        try {
                            ResultSet rs = qexec.execSelect();
                            if (!rs.hasNext()) {
                                if (expectedResultS == null) continue;
                                this.createFailure(results, "Expression returned no result, but expected: " + expectedResultS.getObject(), context);
                                return;
                            }
                            RDFNode result2 = rs.next().get("result");
                            if (expectedResultS == null) {
                                if (result2 == null) continue;
                                this.createFailure(results, "Expression returned a result, but none expected: " + result2, context);
                                return;
                            }
                            if (expectedResultS.getObject().equals(result2)) continue;
                            this.createFailure(results, "Mismatching result. Expected: " + expectedResultS.getObject() + ". Found: " + result2, context);
                            return;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (qexec == null) continue;
                            if (throwable != null) {
                                try {
                                    qexec.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            qexec.close();
                        }
                    }
                    finally {
                        context.tearDownTestContext();
                    }
                }
            }
            finally {
                SPINThreadFunctionRegistry.unregister(old);
                FunctionRegistry.set(ARQ.getContext(), oldFR);
            }
            this.createResult(results, DASH.SuccessTestCaseResult);
        }
    }
}

