/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.constraints.ConstraintViolation;
import org.topbraid.spin.constraints.ObjectPropertyPath;
import org.topbraid.spin.constraints.SimplePropertyPath;
import org.topbraid.spin.constraints.SubjectPropertyPath;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class SHACL2SPINBridge {
    public static ConstraintViolation createConstraintViolation(Resource shResult) {
        Resource path;
        String message = JenaUtil.getStringProperty(shResult, SH.resultMessage);
        Resource root2 = JenaUtil.getResourceProperty(shResult, SH.focusNode);
        LinkedList<SimplePropertyPath> paths = new LinkedList<SimplePropertyPath>();
        if (root2 != null && (path = JenaUtil.getResourceProperty(shResult, SH.resultPath)) != null) {
            if (path.isURIResource()) {
                paths.add(new ObjectPropertyPath(root2, JenaUtil.asProperty(path)));
            } else {
                Resource inverse = JenaUtil.getResourceProperty(path, SH.inversePath);
                if (inverse != null && inverse.isURIResource()) {
                    paths.add(new SubjectPropertyPath(root2, JenaUtil.asProperty(inverse)));
                }
            }
        }
        ConstraintViolation cv = new ConstraintViolation(root2, paths, null, message, null);
        if (shResult.hasProperty(SH.resultSeverity, SH.Violation)) {
            cv.setLevel(SPIN.Error);
        } else if (shResult.hasProperty(SH.resultSeverity, SH.Warning)) {
            cv.setLevel(SPIN.Warning);
        } else if (shResult.hasProperty(SH.resultSeverity, SH.Info)) {
            cv.setLevel(SPIN.Info);
        }
        return cv;
    }

    public static List<ConstraintViolation> createConstraintViolations(Model resultsModel) {
        LinkedList<ConstraintViolation> results = new LinkedList<ConstraintViolation>();
        for (Resource shResult : JenaUtil.getAllInstances(SH.ValidationResult.inModel(resultsModel))) {
            results.add(SHACL2SPINBridge.createConstraintViolation(shResult));
        }
        return results;
    }

    public static Resource createValidationResult(ConstraintViolation cv, Model results) {
        String message;
        Collection<SimplePropertyPath> paths;
        Resource result2 = results.createResource(SPIN.Fatal.equals(cv.getLevel()) ? DASH.FailureResult : SH.ValidationResult);
        if (SPIN.Info.equals(cv.getLevel())) {
            result2.addProperty(SH.resultSeverity, SH.Info);
        } else if (SPIN.Warning.equals(cv.getLevel())) {
            result2.addProperty(SH.resultSeverity, SH.Warning);
        }
        Resource root2 = cv.getRoot();
        if (root2 != null) {
            result2.addProperty(SH.focusNode, root2);
        }
        if ((paths = cv.getPaths()).size() == 1) {
            SimplePropertyPath path = paths.iterator().next();
            result2.addProperty(SH.focusNode, root2);
            if (path instanceof ObjectPropertyPath) {
                result2.addProperty(SH.resultPath, path.getPredicate());
            } else {
                Resource inverse = result2.getModel().createResource();
                inverse.addProperty(SH.inversePath, path.getPredicate());
                result2.addProperty(SH.resultPath, inverse);
            }
            if (cv.getValue() != null) {
                result2.addProperty(SH.value, cv.getValue());
            }
        }
        if ((message = cv.getMessage()) != null) {
            result2.addProperty(SH.resultMessage, message);
        }
        return result2;
    }
}

