/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.sparql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.validation.SHACLException;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.TOSH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.JenaUtil;

public class SPARQLSubstitutions {
    public static boolean useGraphPrefixes = false;
    private static boolean USE_TRANSFORM = false;

    public static void addMessageVarNames(String labelTemplate, Set<String> results) {
        for (int i = 0; i < labelTemplate.length(); ++i) {
            int varEnd;
            if (i >= labelTemplate.length() - 3 || labelTemplate.charAt(i) != '{' || labelTemplate.charAt(i + 1) != '?') continue;
            for (varEnd = i + 2; varEnd < labelTemplate.length(); ++varEnd) {
                if (labelTemplate.charAt(varEnd) != '}') continue;
                String varName = labelTemplate.substring(i + 2, varEnd);
                results.add(varName);
                break;
            }
            i = varEnd;
        }
    }

    public static QueryExecution createQueryExecution(Query query, Dataset dataset, QuerySolution bindings) {
        if (USE_TRANSFORM && bindings != null) {
            HashMap<Var, Node> substitutions = new HashMap<Var, Node>();
            Iterator<String> varNames = bindings.varNames();
            while (varNames.hasNext()) {
                String varName = varNames.next();
                substitutions.put(Var.alloc(varName), bindings.get(varName).asNode());
            }
            Query newQuery = JenaUtil.queryWithSubstitutions(query, substitutions);
            return ARQFactory.get().createQueryExecution(newQuery, dataset);
        }
        return ARQFactory.get().createQueryExecution(query, dataset, bindings);
    }

    public static Query substitutePaths(Query query, String pathString, Model model) {
        String str2 = query.toString().replaceAll(" \\?" + SH.PATHVar.getVarName() + " ", pathString);
        return ARQFactory.get().createQuery(model, str2);
    }

    public static Literal withSubstitutions(Literal template, QuerySolution bindings, Function<RDFNode, String> labelFunction) {
        StringBuffer buffer = new StringBuffer();
        String labelTemplate = template.getLexicalForm();
        for (int i = 0; i < labelTemplate.length(); ++i) {
            if (i < labelTemplate.length() - 3 && labelTemplate.charAt(i) == '{' && (labelTemplate.charAt(i + 1) == '?' || labelTemplate.charAt(i + 1) == '$')) {
                int varEnd;
                for (varEnd = i + 2; varEnd < labelTemplate.length(); ++varEnd) {
                    if (labelTemplate.charAt(varEnd) != '}') continue;
                    String varName = labelTemplate.substring(i + 2, varEnd);
                    RDFNode varValue = bindings.get(varName);
                    if (varValue == null) break;
                    if (labelFunction != null) {
                        buffer.append(labelFunction.apply(varValue));
                        break;
                    }
                    if (varValue instanceof Resource) {
                        buffer.append(SPINLabels.get().getLabel((Resource)varValue));
                        break;
                    }
                    if (!(varValue instanceof Literal)) break;
                    buffer.append(varValue.asNode().getLiteralLexicalForm());
                    break;
                }
                i = varEnd;
                continue;
            }
            buffer.append(labelTemplate.charAt(i));
        }
        if (template.getLanguage().isEmpty()) {
            return ResourceFactory.createTypedLiteral(buffer.toString());
        }
        return ResourceFactory.createLangLiteral(buffer.toString(), template.getLanguage());
    }

    /*
     * WARNING - void declaration
     */
    static void appendTargets(StringBuffer sb, Resource shape, Dataset dataset) {
        LinkedList<String> targets = new LinkedList<String>();
        if (shape.getModel().contains(shape, SH.targetNode, (RDFNode)null)) {
            targets.add("        GRAPH $shapes { $" + SH.currentShapeVar.getName() + " <" + SH.targetNode + "> ?this } .\n");
        }
        if (JenaUtil.hasIndirectType(shape, RDFS.Class)) {
            String varName = "?CLASS_VAR";
            targets.add("        " + (String)varName + " <" + RDFS.subClassOf + ">* $" + SH.currentShapeVar.getName() + " .\n            ?this a " + (String)varName + " .\n");
        }
        for (Resource resource : JenaUtil.getResourceProperties(shape, SH.targetClass)) {
            String varName = "?SHAPE_CLASS_VAR";
            targets.add("        " + varName + " <" + RDFS.subClassOf + ">* <" + resource + "> .\n            ?this a " + varName + " .\n");
        }
        int index = 0;
        for (Resource property : JenaUtil.getResourceProperties(shape, SH.targetSubjectsOf)) {
            targets.add("        ?this <" + property + "> ?ANY_VALUE_" + index++ + " .\n");
        }
        for (Resource property : JenaUtil.getResourceProperties(shape, SH.targetObjectsOf)) {
            targets.add("        ?ANY_VALUE_" + index++ + "  <" + property + "> ?this .\n");
        }
        if (shape.hasProperty(SH.target)) {
            targets.add(SPARQLSubstitutions.createTargets(shape));
        }
        if (targets.isEmpty()) {
            throw new SHACLException("Shape without target " + shape);
        }
        if (targets.size() == 1) {
            sb.append((String)targets.get(0));
        } else {
            void var5_10;
            boolean bl = false;
            while (var5_10 < targets.size()) {
                sb.append("        {");
                sb.append((String)targets.get((int)var5_10));
                sb.append("        }");
                if (var5_10 < targets.size() - 1) {
                    sb.append("        UNION\n");
                }
                ++var5_10;
            }
        }
    }

    private static String createTargets(Resource shape) {
        String targetVar = "?trgt_" + (int)(Math.random() * 10000.0);
        return "        GRAPH $" + SH.shapesGraphVar.getName() + " { $" + SH.currentShapeVar.getName() + " <" + SH.target + "> " + targetVar + "} .\n        (" + targetVar + " $" + SH.shapesGraphVar.getName() + ") <" + TOSH.targetContains + "> ?this .\n";
    }

    public static String withPrefixes(String str2, Resource executable) {
        if (useGraphPrefixes) {
            return ARQFactory.get().createPrefixDeclarations(executable.getModel()) + str2;
        }
        StringBuffer sb = new StringBuffer();
        PrefixMappingImpl pm = new PrefixMappingImpl();
        HashSet<Resource> reached = new HashSet<Resource>();
        for (Resource ontology : JenaUtil.getResourceProperties(executable, SH.prefixes)) {
            String duplicate = SPARQLSubstitutions.collectPrefixes(ontology, pm, reached);
            if (duplicate == null) continue;
            throw new SHACLException("Duplicate prefix declaration for prefix " + duplicate);
        }
        for (String prefix : pm.getNsPrefixMap().keySet()) {
            sb.append("PREFIX ");
            sb.append(prefix);
            sb.append(": <");
            sb.append(pm.getNsPrefixURI(prefix));
            sb.append(">\n");
        }
        sb.append(str2);
        return sb.toString();
    }

    private static String collectPrefixes(Resource ontology, PrefixMapping pm, Set<Resource> reached) {
        reached.add(ontology);
        for (Resource decl : JenaUtil.getResourceProperties(ontology, SH.declare)) {
            String prefix = JenaUtil.getStringProperty(decl, SH.prefix);
            String ns = JenaUtil.getStringProperty(decl, SH.namespace);
            if (prefix == null || ns == null) continue;
            String oldNS = pm.getNsPrefixURI(prefix);
            if (oldNS != null && !oldNS.equals(ns)) {
                return prefix;
            }
            pm.setNsPrefix(prefix, ns);
        }
        for (Resource imp : JenaUtil.getResourceProperties(ontology, OWL.imports)) {
            String duplicate;
            if (reached.contains(imp) || (duplicate = SPARQLSubstitutions.collectPrefixes(imp, pm, reached)) == null) continue;
            return duplicate;
        }
        return null;
    }
}

