/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.IterLib;

public class PropertyChainHelperPFunction
extends PropertyFunctionBase {
    @Override
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterConcat concat2 = new QueryIterConcat(execCxt);
        argSubject = Substitute.substitute(argSubject, binding);
        argObject = Substitute.substitute(argObject, binding);
        Model model = ModelFactory.createModelForGraph(execCxt.getActiveGraph());
        RDFList rdfList = model.asRDFNode(argSubject.getArg()).as(RDFList.class);
        List<RDFNode> ps = rdfList.asJavaList();
        Property[] properties = new Property[ps.size()];
        for (int i = 0; i < ps.size(); ++i) {
            properties[i] = ps.get(i).as(Property.class);
        }
        List<Node> objectList = argObject.getArgList();
        Var subjectVar = (Var)objectList.get(0);
        Var objectVar = (Var)objectList.get(1);
        if (ps.size() > 1) {
            StmtIterator it = model.listStatements(null, properties[0], (RDFNode)null);
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                LinkedList<Node> tails = new LinkedList<Node>();
                if (!s.getObject().isResource()) continue;
                this.addTails(properties, 1, s.getResource(), tails);
                for (Node tail : tails) {
                    BindingHashMap map = new BindingHashMap(binding);
                    map.add(subjectVar, s.getSubject().asNode());
                    map.add(objectVar, tail);
                    concat2.add(IterLib.result(map, execCxt));
                }
            }
        }
        return concat2;
    }

    private void addTails(Property[] properties, int i, Resource subject, List<Node> results) {
        if (i == properties.length) {
            results.add(subject.asNode());
        } else {
            StmtIterator it = subject.listProperties(properties[i]);
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                if (!s.getObject().isResource()) continue;
                this.addTails(properties, i + 1, s.getResource(), results);
            }
        }
    }
}

