/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.topbraid.spin.arq.SPINARQFunction;

public class SPINFunctionsCache {
    private static SPINFunctionsCache singleton = new SPINFunctionsCache();
    private static final int capacity = 10000;
    private Map<Key, Result> cache = Collections.synchronizedMap(new MyCache());

    public static SPINFunctionsCache get() {
        return singleton;
    }

    public static void set(SPINFunctionsCache value) {
        singleton = value;
    }

    public void clear() {
        this.cache.clear();
    }

    public NodeValue execute(SPINARQFunction function, Dataset dataset, Model defaultModel, QuerySolution bindings, Node[] args) {
        Key key = new Key(function.getSPINFunction().getURI(), args);
        Result result2 = this.cache.get(key);
        if (result2 == null) {
            result2 = new Result();
            try {
                result2.nodeValue = function.executeBody(dataset, defaultModel, bindings);
            }
            catch (ExprEvalException ex) {
                result2.ex = ex;
            }
            this.cache.put(key, result2);
        }
        if (result2.ex != null) {
            throw new ExprEvalException(result2.ex.getMessage());
        }
        return result2.nodeValue;
    }

    private static class Result {
        ExprEvalException ex;
        NodeValue nodeValue;

        private Result() {
        }
    }

    private static class Key {
        private int hashCode;
        private Node[] args;
        private String functionURI;

        Key(String functionURI, Node[] args) {
            this.args = args;
            this.functionURI = functionURI;
            this.hashCode = functionURI.hashCode();
            for (Node arg : args) {
                if (arg == null) continue;
                this.hashCode += arg.hashCode();
            }
        }

        private boolean argEquals(Node arg1, Node arg2) {
            if (arg1 == null) {
                return arg2 == null;
            }
            if (arg2 == null) {
                return false;
            }
            return arg1.equals(arg2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.functionURI.equals(other.functionURI)) {
                return false;
            }
            if (this.args.length != other.args.length) {
                return false;
            }
            for (int i = 0; i < this.args.length; ++i) {
                if (this.argEquals(this.args[i], other.args[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            String str2 = "<" + this.functionURI + ">(";
            for (int i = 0; i < this.args.length; ++i) {
                if (i > 0) {
                    str2 = str2 + ", ";
                }
                str2 = str2 + this.args[i];
            }
            return str2 + ")";
        }
    }

    private static class MyCache
    extends LinkedHashMap<Key, Result> {
        MyCache() {
            super(10001, 1.1f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, Result> eldest) {
            return this.size() > 10000;
        }
    }
}

