/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.Iterator;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterBlockTriples;
import org.apache.jena.sparql.engine.main.StageBuilder;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.topbraid.spin.arq.SPINThreadFunctions;

public class SPINThreadFunctionRegistry
extends FunctionRegistry {
    private static ThreadLocal<SPINThreadFunctions> localFunctions;
    private FunctionRegistry base;

    public static SPINThreadFunctions register(Model model) {
        SPINThreadFunctions old = localFunctions.get();
        SPINThreadFunctions neo = new SPINThreadFunctions(model);
        localFunctions.set(neo);
        return old;
    }

    public static void unregister(SPINThreadFunctions old) {
        if (old != null) {
            localFunctions.set(old);
        } else {
            localFunctions.remove();
        }
    }

    public static SPINThreadFunctions getFunctions() {
        return localFunctions.get();
    }

    public SPINThreadFunctionRegistry(FunctionRegistry base) {
        this.base = base;
    }

    @Override
    public FunctionFactory get(String uri) {
        FunctionFactory ff;
        FunctionFactory b = this.base.get(uri);
        if (b != null) {
            return b;
        }
        SPINThreadFunctions functions = localFunctions.get();
        if (functions != null && (ff = functions.getFunctionFactory(uri)) != null) {
            return ff;
        }
        return null;
    }

    @Override
    public boolean isRegistered(String uri) {
        if (this.base.isRegistered(uri)) {
            return true;
        }
        return this.get(uri) != null;
    }

    @Override
    public Iterator<String> keys() {
        return this.base.keys();
    }

    @Override
    public void put(String uri, Class<?> funcClass) {
        this.base.put(uri, funcClass);
    }

    @Override
    public void put(String uri, FunctionFactory f) {
        this.base.put(uri, f);
    }

    @Override
    public FunctionFactory remove(String uri) {
        return this.base.remove(uri);
    }

    static {
        StageBuilder.setGenerator(ARQ.getContext(), new StageGenerator(){

            @Override
            public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
                return QueryIterBlockTriples.create(input, pattern, execCxt);
            }
        });
        localFunctions = new ThreadLocal();
    }
}

