/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.AbstractFunction;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;

public abstract class AbstractWalkFunction
extends AbstractFunction {
    @Override
    protected NodeValue exec(Node[] nodes, FunctionEnv env) {
        Node startNode = nodes[0];
        Node predicate = nodes[1];
        Node function = nodes[2];
        Model model = ModelFactory.createModelForGraph(env.getActiveGraph());
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        StringBuffer expression = new StringBuffer("<" + function + ">(?arg1");
        for (int i = 3; i < nodes.length; ++i) {
            expression.append(", ");
            expression.append("?");
            String varName = "arg" + (i - 1);
            expression.append(varName);
            if (nodes[i] == null) continue;
            initialBinding.add(varName, model.asRDFNode(nodes[i]));
        }
        expression.append(")");
        Query query = ARQFactory.get().createExpressionQuery(expression.toString());
        Node result2 = this.walkTree(model, DatasetImpl.wrap(env.getDataset()), startNode, predicate, query, initialBinding, new HashSet<Node>());
        if (result2 != null) {
            return NodeValue.makeNode(result2);
        }
        throw new ExprEvalException("No result");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node walkTree(Model model, Dataset oldDataset, Node node, Node predicate, Query query, QuerySolution initialBinding, Set<Node> reached) {
        QuerySolutionMap localBinding = new QuerySolutionMap();
        localBinding.addAll(initialBinding);
        localBinding.add("arg1", model.asRDFNode(node));
        DatasetWithDifferentDefaultModel dataset = new DatasetWithDifferentDefaultModel(model, oldDataset);
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, dataset, (QuerySolution)localBinding);){
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext()) {
                List<String> resultVars = rs.getResultVars();
                String varName = resultVars.get(0);
                RDFNode resultNode = rs.next().get(varName);
                if (resultNode != null) {
                    Node node2 = resultNode.asNode();
                    return node2;
                }
            }
        }
        try (ExtendedIterator<Triple> it = this.createIterator(model.getGraph(), node, predicate);){
            Node nextResult;
            block23: {
                while (it.hasNext()) {
                    Node next = this.getNext((Triple)it.next());
                    if (!next.isBlank() && !next.isURI() || reached.contains(next)) continue;
                    reached.add(next);
                    nextResult = this.walkTree(model, oldDataset, next, predicate, query, initialBinding, reached);
                    if (nextResult == null) {
                        continue;
                    }
                    break block23;
                }
                return null;
            }
            Node node3 = nextResult;
            return node3;
        }
    }

    protected abstract ExtendedIterator<Triple> createIterator(Graph var1, Node var2, Node var3);

    protected abstract Node getNext(Triple var1);
}

