/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq.functions;

import java.util.List;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.IterLib;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.arq.functions.SPINFunctionUtil;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.vocabulary.SPIN;

public class ConstructPFunction
extends PropertyFunctionBase {
    private static final String NAME = "spin:" + SPIN.construct.getLocalName();

    @Override
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Query spinQuery;
        argSubject = Substitute.substitute(argSubject, binding);
        List<Node> objects = SPINFunctionUtil.getNodes(argObject = Substitute.substitute(argObject, binding));
        if (objects.size() != 3) {
            throw new ExprEvalException(NAME + " must have three nodes on the right side");
        }
        Model model = ModelFactory.createModelForGraph(execCxt.getActiveGraph());
        QuerySolutionMap initialBinding = SPINFunctionUtil.getInitialBinding(SPINFunctionUtil.getNodes(argSubject).toArray(new Node[0]), model);
        Resource qot = SPINFunctionUtil.getQueryOrTemplateCall(argSubject, model);
        if (SPINFactory.isTemplateCall(qot)) {
            TemplateCall templateCall = SPINFactory.asTemplateCall(qot);
            spinQuery = SPINFactory.asQuery(templateCall.getTemplate().getBody());
            SPINFunctionUtil.addBindingsFromTemplateCall(initialBinding, templateCall);
        } else {
            spinQuery = SPINFactory.asQuery(qot);
        }
        org.apache.jena.query.Query arqQuery = ARQFactory.get().createQuery(spinQuery);
        DatasetWithDifferentDefaultModel dataset = new DatasetWithDifferentDefaultModel(model, DatasetImpl.wrap(execCxt.getDataset()));
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(arqQuery, dataset, (QuerySolution)initialBinding);){
            Model result2 = qexec.execConstruct();
            QueryIterConcat concat2 = new QueryIterConcat(execCxt);
            for (Triple triple : GraphUtil.findAll(result2.getGraph()).toList()) {
                BindingHashMap bindingMap = new BindingHashMap(binding);
                if (!this.perhapsAdd(objects.get(0), triple.getSubject(), bindingMap) || !this.perhapsAdd(objects.get(1), triple.getPredicate(), bindingMap) || !this.perhapsAdd(objects.get(2), triple.getObject(), bindingMap)) continue;
                concat2.add(IterLib.result(bindingMap, execCxt));
            }
            QueryIterConcat queryIterConcat = concat2;
            return queryIterConcat;
        }
    }

    private boolean perhapsAdd(Node matchNode, Node tripleNode, BindingMap bindingMap) {
        if (matchNode == null) {
            if (tripleNode != null) {
                return false;
            }
        } else if (matchNode.isVariable()) {
            if (tripleNode != null) {
                bindingMap.add((Var)matchNode, tripleNode);
            }
        } else if (tripleNode == null || !matchNode.matches(tripleNode)) {
            return false;
        }
        return true;
    }
}

