/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq.functions;

import java.util.Collections;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterExtendByVar;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.IterLib;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.arq.functions.SPINFunctionUtil;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.vocabulary.SPIN;

public class SelectPFunction
extends PropertyFunctionBase {
    private static final String NAME = "spin:" + SPIN.select.getLocalName();

    @Override
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Query spinQuery;
        argSubject = Substitute.substitute(argSubject, binding);
        List<Node> objects = SPINFunctionUtil.getNodes(argObject = Substitute.substitute(argObject, binding));
        if (objects.isEmpty()) {
            throw new ExprEvalException(NAME + " must have at least one node on the right side");
        }
        Model model = ModelFactory.createModelForGraph(execCxt.getActiveGraph());
        Resource qot = SPINFunctionUtil.getQueryOrTemplateCall(argSubject, model);
        QuerySolutionMap initialBinding = SPINFunctionUtil.getInitialBinding(SPINFunctionUtil.getNodes(argSubject).toArray(new Node[0]), model);
        if (SPINFactory.isTemplateCall(qot)) {
            TemplateCall templateCall = SPINFactory.asTemplateCall(qot);
            spinQuery = SPINFactory.asQuery(templateCall.getTemplate().getBody());
            SPINFunctionUtil.addBindingsFromTemplateCall(initialBinding, templateCall);
        } else {
            spinQuery = SPINFactory.asQuery(qot);
            if (spinQuery == null) {
                throw new IllegalArgumentException("First argument on the left hand side of spin:select must be a query (e.g. sp:Select) or an instance of a SPIN template");
            }
        }
        org.apache.jena.query.Query arqQuery = ARQFactory.get().createQuery(spinQuery);
        DatasetWithDifferentDefaultModel dataset = new DatasetWithDifferentDefaultModel(model, DatasetImpl.wrap(execCxt.getDataset()));
        Throwable throwable = null;
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(arqQuery, dataset, (QuerySolution)initialBinding);){
            if (arqQuery.isAskType()) {
                QueryIterator queryIterator = this.handleAsk(qexec.execAsk(), objects, binding, execCxt);
                return queryIterator;
            }
            if (arqQuery.isSelectType()) {
                QueryIterator queryIterator = this.handleSelect(qexec.execSelect(), objects, binding, execCxt);
                return queryIterator;
            }
            try {
                throw new ExprEvalException(NAME + " can only operate on SELECT or ASK queries");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private QueryIterator handleAsk(boolean result2, List<Node> objects, Binding binding, ExecutionContext execCxt) {
        Node resultNode = result2 ? JenaDatatypes.TRUE.asNode() : JenaDatatypes.FALSE.asNode();
        Node firstObject = objects.get(0);
        if (firstObject.isVariable()) {
            return new QueryIterExtendByVar(binding, (Var)firstObject, Collections.singletonList(resultNode).iterator(), execCxt);
        }
        if (resultNode.matches(firstObject)) {
            return IterLib.result(binding, execCxt);
        }
        throw new ExprEvalException("No match");
    }

    private QueryIterator handleSelect(ResultSet rs, List<Node> objects, Binding binding, ExecutionContext execCxt) {
        List<String> resultVars = rs.getResultVars();
        QueryIterConcat concat2 = new QueryIterConcat(execCxt);
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            BindingHashMap bindingMap = new BindingHashMap(binding);
            boolean use = true;
            for (int i = 0; i < resultVars.size() && i < objects.size(); ++i) {
                Node object = objects.get(i);
                RDFNode result2 = qs.get(resultVars.get(i));
                if (object == null) {
                    if (result2 == null) continue;
                    use = false;
                    break;
                }
                if (object.isVariable()) {
                    if (result2 == null) continue;
                    bindingMap.add((Var)object, result2.asNode());
                    continue;
                }
                if (result2 != null && object.matches(result2.asNode())) continue;
                use = false;
                break;
            }
            if (!use) continue;
            concat2.add(IterLib.result(bindingMap, execCxt));
        }
        return concat2;
    }
}

