/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.inference;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TransactionalNotSupported;
import org.apache.jena.sparql.util.Context;
import org.topbraid.spin.inference.ControlledUpdateGraph;

class ControlledUpdateGraphStore
extends TransactionalNotSupported
implements DatasetGraph {
    private Map<Graph, ControlledUpdateGraph> cugs = new HashMap<Graph, ControlledUpdateGraph>();
    private Dataset dataset;

    ControlledUpdateGraphStore(Dataset dataset, Iterable<Graph> controlledGraphs) {
        this.dataset = dataset;
        for (Graph graph : controlledGraphs) {
            ControlledUpdateGraph cug = new ControlledUpdateGraph(graph);
            this.cugs.put(graph, cug);
        }
    }

    @Override
    public Graph getUnionGraph() {
        throw new UnsupportedOperationException("getUnionGraph");
    }

    @Override
    public void clear() {
    }

    private Graph getControlledUpdateGraph(Graph graph) {
        Graph cug = this.cugs.get(graph);
        if (cug != null) {
            return cug;
        }
        return graph;
    }

    public Iterable<ControlledUpdateGraph> getControlledUpdateGraphs() {
        return this.cugs.values();
    }

    @Override
    public Graph getDefaultGraph() {
        Model defaultModel = this.dataset.getDefaultModel();
        if (defaultModel != null) {
            return this.getControlledUpdateGraph(defaultModel.getGraph());
        }
        return null;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Model model = this.dataset.getNamedModel(graphNode.getURI());
        if (model != null) {
            return this.getControlledUpdateGraph(model.getGraph());
        }
        return null;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.dataset.containsNamedModel(graphNode.getURI());
    }

    @Override
    public void setDefaultGraph(Graph g) {
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
    }

    @Override
    public void removeGraph(Node graphName) {
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        LinkedList<Node> results = new LinkedList<Node>();
        Iterator<String> it = this.dataset.listNames();
        while (it.hasNext()) {
            results.add(NodeFactory.createURI(it.next()));
        }
        return results.iterator();
    }

    @Override
    public void add(Quad quad) {
        Graph graph = quad.isDefaultGraph() ? this.getDefaultGraph() : this.getGraph(quad.getGraph());
        if (graph != null) {
            graph.add(quad.asTriple());
        }
    }

    @Override
    public void delete(Quad quad) {
        Graph graph = quad.isDefaultGraph() ? this.getDefaultGraph() : this.getGraph(quad.getGraph());
        if (graph != null) {
            graph.delete(quad.asTriple());
        }
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.find(g, s, p, o);
        List<Quad> list = Iter.toList(iter);
        for (Quad q : list) {
            this.delete(q);
        }
    }

    @Override
    public Iterator<Quad> find() {
        return null;
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        return null;
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return null;
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return null;
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        Graph graph = this.getGraph(g);
        if (graph != null) {
            return graph.contains(s, p, o);
        }
        return false;
    }

    @Override
    public boolean contains(Quad quad) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Lock getLock() {
        return null;
    }

    @Override
    public Context getContext() {
        return ARQ.getContext();
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public void close() {
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.add(Quad.create(g, s, p, o));
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.delete(Quad.create(g, s, p, o));
    }
}

