/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.inference.ControlledUpdateGraph;
import org.topbraid.spin.inference.ControlledUpdateGraphStore;
import org.topbraid.spin.inference.SPINExplanations;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.AbstractGraphListener;
import org.topbraid.spin.util.CommandWrapper;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.QueryWrapper;
import org.topbraid.spin.util.SPINQueryFinder;
import org.topbraid.spin.util.UpdateUtil;
import org.topbraid.spin.util.UpdateWrapper;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINConstructors {
    public static void construct(Model queryModel, List<Resource> instances, Model targetModel, ProgressMonitor monitor) {
        Map<Resource, List<CommandWrapper>> class2Constructor = SPINQueryFinder.getClass2QueryMap(queryModel, queryModel, SPIN.constructor, true, false);
        SPINConstructors.construct(queryModel, instances, targetModel, new HashSet<Resource>(), class2Constructor, monitor);
    }

    public static void construct(Model queryModel, List<Resource> instances, Model targetModel, Set<Resource> reached, Map<Resource, List<CommandWrapper>> class2Constructor, ProgressMonitor monitor) {
        SPINConstructors.construct(queryModel, instances, targetModel, reached, class2Constructor, null, null, monitor);
    }

    public static void construct(Model queryModel, List<Resource> instances, Model targetModel, Set<Resource> reached, Map<Resource, List<CommandWrapper>> class2Constructor, List<SPINStatistics> statistics, SPINExplanations explanations, ProgressMonitor monitor) {
        if (!instances.isEmpty()) {
            ArrayList<Resource> newResources = new ArrayList<Resource>();
            for (Resource instance : instances) {
                if (reached.contains(instance)) continue;
                reached.add(instance);
                SPINConstructors.constructInstance(queryModel, instance, targetModel, newResources, class2Constructor, statistics, explanations, monitor);
            }
            SPINConstructors.construct(queryModel, newResources, targetModel, reached, class2Constructor, statistics, explanations, monitor);
        }
    }

    public static void constructInstance(Model queryModel, Resource instance, Model targetModel, List<Resource> newResources, Map<Resource, List<CommandWrapper>> class2Constructor, List<SPINStatistics> statistics, SPINExplanations explanations, ProgressMonitor monitor) {
        for (Statement s : instance.listProperties(RDF.type).toList()) {
            Resource type = s.getResource();
            SPINConstructors.constructInstance(queryModel, instance, type, targetModel, newResources, new HashSet<Resource>(), class2Constructor, statistics, explanations, monitor);
        }
    }

    public static void constructInstance(Model queryModel, Resource instance, Resource type, Model targetModel, List<Resource> newResources, Set<Resource> reachedTypes, Map<Resource, List<CommandWrapper>> class2Constructor, List<SPINStatistics> statistics, SPINExplanations explanations, ProgressMonitor monitor) {
        for (Statement s : type.listProperties(RDFS.subClassOf).toList()) {
            Resource superClass = s.getResource();
            if (reachedTypes.contains(superClass)) continue;
            reachedTypes.add(superClass);
            SPINConstructors.constructInstance(queryModel, instance, superClass, targetModel, newResources, reachedTypes, class2Constructor, statistics, explanations, monitor);
        }
        List<CommandWrapper> commandWrappers = class2Constructor.get(type);
        if (commandWrappers != null) {
            for (CommandWrapper commandWrapper : commandWrappers) {
                Map<String, RDFNode> initialBindings;
                QuerySolutionMap bindings = new QuerySolutionMap();
                if (instance != null) {
                    bindings.add("this", instance);
                }
                if ((initialBindings = commandWrapper.getTemplateBinding()) != null) {
                    for (String varName : initialBindings.keySet()) {
                        RDFNode value = initialBindings.get(varName);
                        bindings.add(varName, value);
                    }
                }
                if (monitor != null) {
                    monitor.subTask("TopSPIN constructor at " + SPINLabels.get().getLabel(instance) + ": " + commandWrapper.getText());
                }
                long startTime = System.currentTimeMillis();
                if (commandWrapper instanceof QueryWrapper) {
                    final LinkedList triples = new LinkedList();
                    AbstractGraphListener listener = new AbstractGraphListener(){

                        @Override
                        public void notifyAddTriple(Graph g, Triple t) {
                            triples.add(t);
                        }

                        @Override
                        public void notifyDeleteTriple(Graph g, Triple t) {
                        }

                        @Override
                        protected void notifyRemoveAll(Graph source, Triple pattern) {
                        }
                    };
                    QueryWrapper queryWrapper = (QueryWrapper)commandWrapper;
                    Query arqQuery = queryWrapper.getQuery();
                    if (arqQuery.isConstructType()) {
                        QueryExecution qexec = ARQFactory.get().createQueryExecution(arqQuery, queryModel, (QuerySolution)bindings);
                        Object object = null;
                        try {
                            Model resultModel = ModelFactory.createDefaultModel();
                            resultModel.getGraph().getEventManager().register(listener);
                            qexec.execConstruct(resultModel);
                        }
                        catch (Throwable resultModel) {
                            object = resultModel;
                            throw resultModel;
                        }
                        finally {
                            if (qexec != null) {
                                if (object != null) {
                                    try {
                                        qexec.close();
                                    }
                                    catch (Throwable resultModel) {
                                        ((Throwable)object).addSuppressed(resultModel);
                                    }
                                } else {
                                    qexec.close();
                                }
                            }
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append("Inferred by SPIN constructor at class ");
                        sb.append(SPINLabels.get().getLabel(type));
                        sb.append(":\n\n" + commandWrapper.getText());
                        String explanationText = sb.toString();
                        for (Triple triple : triples) {
                            Resource subject;
                            Statement rs = queryModel.asStatement(triple);
                            if (targetModel.contains(rs)) continue;
                            targetModel.add(rs);
                            if (RDF.type.equals(rs.getPredicate()) && !newResources.contains(subject = rs.getSubject())) {
                                newResources.add(subject);
                            }
                            if (explanations == null) continue;
                            Resource source = commandWrapper.getStatement().getSubject();
                            explanations.put(triple, explanationText, source.asNode(), commandWrapper.getSource() != null ? commandWrapper.getSource().asNode() : null);
                        }
                    }
                } else if (commandWrapper instanceof UpdateWrapper) {
                    Update update = ((UpdateWrapper)commandWrapper).getUpdate();
                    Dataset dataset = ARQFactory.get().getDataset(queryModel);
                    Collection<Graph> updateGraphs = UpdateUtil.getUpdatedGraphs(update, dataset.asDatasetGraph(), initialBindings);
                    ControlledUpdateGraphStore cugs = new ControlledUpdateGraphStore(dataset, updateGraphs);
                    UpdateProcessor up = UpdateExecutionFactory.create(update, (DatasetGraph)cugs, JenaUtil.asBinding(bindings));
                    up.execute();
                    for (ControlledUpdateGraph cug : cugs.getControlledUpdateGraphs()) {
                        for (Triple triple : cug.getAddedTriples()) {
                            Resource subject;
                            Statement rs = queryModel.asStatement(triple);
                            if (!RDF.type.equals(rs.getPredicate()) || newResources.contains(subject = rs.getSubject())) continue;
                            newResources.add(subject);
                        }
                    }
                }
                long endTime = System.currentTimeMillis();
                if (statistics == null) continue;
                String queryText = SPINLabels.get().getLabel(commandWrapper.getSPINCommand());
                String label = commandWrapper.getLabel();
                if (label == null) {
                    label = queryText;
                }
                statistics.add(new SPINStatistics(label, queryText, endTime - startTime, startTime, instance.asNode()));
            }
        }
    }

    public static void constructAll(Model queryModel, Model targetModel, ProgressMonitor monitor) {
        Set<Resource> classes = SPINConstructors.getClassesWithConstructor(queryModel);
        ArrayList<Resource> instances = new ArrayList<Resource>(SPINConstructors.getInstances(classes));
        OntModel ontModel = JenaUtil.createOntologyModel(OntModelSpec.OWL_MEM, queryModel);
        if (targetModel != queryModel) {
            ontModel.addSubModel(targetModel);
        }
        Map<Resource, List<CommandWrapper>> class2Constructor = SPINQueryFinder.getClass2QueryMap(queryModel, queryModel, SPIN.constructor, true, false);
        SPINConstructors.construct(ontModel, instances, targetModel, new HashSet<Resource>(), class2Constructor, monitor);
    }

    public static Set<Resource> getClassesWithConstructor(Model model) {
        HashSet<Resource> results = new HashSet<Resource>();
        for (Property property : SPINConstructors.getConstructorProperties(model)) {
            StmtIterator it = model.listStatements(null, property, (RDFNode)null);
            while (it.hasNext()) {
                results.add(((Statement)it.next()).getSubject());
            }
        }
        return results;
    }

    private static Iterable<Property> getConstructorProperties(Model model) {
        ArrayList<Property> results = new ArrayList<Property>();
        for (Resource r : JenaUtil.getAllSubProperties(model.getProperty(SPIN.constructor.getURI()))) {
            results.add(model.getProperty(r.getURI()));
        }
        results.add(model.getProperty(SPIN.constructor.getURI()));
        return results;
    }

    private static Set<Resource> getInstances(Collection<Resource> classes) {
        HashSet<Resource> results = new HashSet<Resource>();
        for (Resource cls : classes) {
            results.addAll(JenaUtil.getAllInstances(cls));
        }
        return results;
    }

    public static boolean hasConstructor(Resource cls) {
        for (Property property : SPINConstructors.getConstructorProperties(cls.getModel())) {
            if (cls.hasProperty(property)) {
                return true;
            }
            for (Resource superClass : JenaUtil.getAllSuperClasses(cls)) {
                if (!superClass.hasProperty(property)) continue;
                return true;
            }
        }
        return false;
    }
}

