/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.spin.model.Filter;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.impl.ElementImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.vocabulary.SP;

public class FilterImpl
extends ElementImpl
implements Filter {
    public FilterImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public RDFNode getExpression() {
        Statement s = this.getProperty(SP.expression);
        if (s != null) {
            RDFNode object = s.getObject();
            return SPINFactory.asExpression(object);
        }
        return null;
    }

    @Override
    public void print(PrintContext context) {
        context.printKeyword("FILTER");
        context.print(" ");
        RDFNode expression = this.getExpression();
        if (expression == null) {
            context.print("<Error: Missing expression>");
        } else {
            this.printNestedExpressionString(context, expression, true);
        }
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

