/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathWriter;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.model.TriplePath;
import org.topbraid.spin.model.impl.TupleImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;

public class TriplePathImpl
extends TupleImpl
implements TriplePath {
    public TriplePathImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void print(PrintContext p) {
        this.print(this.getSubject(), p);
        p.print(" ");
        Statement pathS = this.getProperty(SP.path);
        if (pathS == null || pathS.getObject().isLiteral()) {
            p.print("<Missing path>");
        } else {
            Resource path = pathS.getResource();
            this.printPath(path, p);
        }
        p.print(" ");
        this.print(this.getObject(), p);
    }

    private void printPath(Resource path, PrintContext p) {
        Path arqPath = this.createPath(path);
        if (p.getUsePrefixes()) {
            PrefixMapping prefixMapping = path.getModel().getGraph().getPrefixMapping();
            String str2 = PathWriter.asString(arqPath, new Prologue(prefixMapping));
            p.print(str2);
        } else {
            String str3 = PathWriter.asString(arqPath);
            p.print(str3);
        }
    }

    private Path createPath(Resource path) {
        if (path.isURIResource()) {
            return new P_Link(path.asNode());
        }
        Statement typeS = path.getProperty(RDF.type);
        if (typeS != null && typeS.getObject().isURIResource()) {
            Resource type = typeS.getResource();
            if (SP.AltPath.equals(type)) {
                Path leftPath = this.createPath(path, SP.path1);
                Path rightPath = this.createPath(path, SP.path2);
                return new P_Alt(leftPath, rightPath);
            }
            if (SP.ModPath.equals(type)) {
                Path subPath = this.createPath(path, SP.subPath);
                long min2 = path.getProperty(SP.modMin).getLong();
                long max2 = path.getProperty(SP.modMax).getLong();
                if (max2 < 0L) {
                    if (min2 == 1L) {
                        return new P_OneOrMore1(subPath);
                    }
                    if (max2 == -1L) {
                        return new P_ZeroOrOne(subPath);
                    }
                    return new P_ZeroOrMore1(subPath);
                }
                return new P_Mod(subPath, min2, max2);
            }
            if (SP.ReversePath.equals(type)) {
                Path subPath = this.createPath(path, SP.subPath);
                return new P_Inverse(subPath);
            }
            if (SP.SeqPath.equals(type)) {
                Path leftPath = this.createPath(path, SP.path1);
                Path rightPath = this.createPath(path, SP.path2);
                return new P_Seq(leftPath, rightPath);
            }
            if (SP.ReverseLinkPath.equals(type)) {
                Node node = JenaUtil.getProperty(path, SP.node).asNode();
                return new P_ReverseLink(node);
            }
        }
        return null;
    }

    private Path createPath(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().isResource()) {
            return this.createPath(s.getResource());
        }
        return null;
    }
}

