/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.AbstractSPINResourceImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.util.SPINExpressions;
import org.topbraid.spin.vocabulary.SP;

abstract class TupleImpl
extends AbstractSPINResourceImpl {
    public TupleImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    public RDFNode getObject() {
        return this.getRDFNodeOrVariable(SP.object);
    }

    public Resource getObjectResource() {
        RDFNode node = this.getRDFNodeOrVariable(SP.object);
        if (node instanceof Resource) {
            return (Resource)node;
        }
        return null;
    }

    public RDFNode getSubject() {
        return this.getRDFNodeOrVariable(SP.subject);
    }

    protected RDFNode getRDFNodeOrVariable(Property predicate) {
        RDFNode node = this.getRDFNode(predicate);
        if (node != null) {
            Variable var = SPINFactory.asVariable(node);
            if (var != null) {
                return var;
            }
            return node;
        }
        return null;
    }

    protected void print(RDFNode node, PrintContext p) {
        TupleImpl.print(this.getModel(), node, p);
    }

    protected void print(RDFNode node, PrintContext p, boolean abbrevRDFType) {
        TupleImpl.print(this.getModel(), node, p, abbrevRDFType);
    }

    public static void print(Model model, RDFNode node, PrintContext p) {
        TupleImpl.print(model, node, p, false);
    }

    public static void print(Model model, RDFNode node, PrintContext p, boolean abbrevRDFType) {
        if (node instanceof Resource) {
            if (abbrevRDFType && RDF.type.equals(node)) {
                p.print("a");
            } else {
                Resource resource = (Resource)node;
                TupleImpl.printVarOrResource(p, resource);
            }
        } else {
            PrefixMapping pm = p.getUsePrefixes() ? model.getGraph().getPrefixMapping() : SPINExpressions.emptyPrefixMapping;
            String str2 = FmtUtils.stringForNode(node.asNode(), pm);
            p.print(str2);
        }
    }
}

