/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.update.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.spin.arq.ARQ2SPIN;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.NamedGraph;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TripleTemplate;
import org.topbraid.spin.model.impl.AbstractSPINResourceImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.update.Update;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;

public abstract class UpdateImpl
extends AbstractSPINResourceImpl
implements Update {
    public UpdateImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    public ElementList getWhere() {
        Statement whereS = this.getProperty(SP.where);
        if (whereS != null) {
            Element element = SPINFactory.asElement(whereS.getResource());
            return (ElementList)element;
        }
        return null;
    }

    public boolean isSilent() {
        return this.hasProperty(SP.silent, JenaDatatypes.TRUE);
    }

    @Override
    public void print(PrintContext p) {
        String text = ARQ2SPIN.getTextOnly(this);
        if (text != null) {
            p.print(text);
        } else {
            this.printSPINRDF(p);
        }
    }

    protected abstract void printSPINRDF(PrintContext var1);

    protected void printGraphDefaultNamedOrAll(PrintContext p) {
        Resource graph = JenaUtil.getResourceProperty(this, SP.graphIRI);
        if (graph != null) {
            p.printKeyword("GRAPH");
            p.print(" ");
            p.printURIResource(graph);
        } else if (this.hasProperty(SP.default_, JenaDatatypes.TRUE)) {
            p.printKeyword("DEFAULT");
        } else if (this.hasProperty(SP.named, JenaDatatypes.TRUE)) {
            p.printKeyword("NAMED");
        } else if (this.hasProperty(SP.all, JenaDatatypes.TRUE)) {
            p.printKeyword("ALL");
        }
    }

    protected void printGraphIRIs(PrintContext p, String keyword) {
        ArrayList<String> graphIRIs = new ArrayList<String>();
        StmtIterator it = this.listProperties(SP.graphIRI);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isURIResource()) continue;
            graphIRIs.add(s.getResource().getURI());
        }
        Collections.sort(graphIRIs);
        for (String graphIRI : graphIRIs) {
            p.print(" ");
            if (keyword != null) {
                p.printKeyword(keyword);
                p.print(" ");
            }
            p.printURIResource(this.getModel().getResource(graphIRI));
        }
    }

    protected void printSilent(PrintContext p) {
        if (this.isSilent()) {
            p.printKeyword("SILENT");
            p.print(" ");
        }
    }

    protected boolean printTemplates(PrintContext p, Property predicate, String keyword, boolean force, Resource graphIRI) {
        List<RDFNode> nodes = this.getList(predicate);
        if (!nodes.isEmpty() || force) {
            if (keyword != null) {
                p.printIndentation(p.getIndentation());
                p.printKeyword(keyword);
            }
            p.print(" {");
            p.println();
            if (graphIRI != null) {
                p.setIndentation(p.getIndentation() + 1);
                p.printIndentation(p.getIndentation());
                p.printKeyword("GRAPH");
                p.print(" ");
                UpdateImpl.printVarOrResource(p, graphIRI);
                p.print(" {");
                p.println();
            }
            for (RDFNode node : nodes) {
                p.printIndentation(p.getIndentation() + 1);
                if (node.canAs(NamedGraph.class)) {
                    NamedGraph namedGraph = node.as(NamedGraph.class);
                    p.setIndentation(p.getIndentation() + 1);
                    p.setNamedBNodeMode(true);
                    namedGraph.print(p);
                    p.setNamedBNodeMode(false);
                    p.setIndentation(p.getIndentation() - 1);
                } else {
                    TripleTemplate template = node.as(TripleTemplate.class);
                    template.print(p);
                }
                p.print(" .");
                p.println();
            }
            if (graphIRI != null) {
                p.printIndentation(p.getIndentation());
                p.setIndentation(p.getIndentation() - 1);
                p.print("}");
                p.println();
            }
            p.printIndentation(p.getIndentation());
            p.print("}");
            return true;
        }
        return false;
    }

    protected void printWhere(PrintContext p) {
        p.printIndentation(p.getIndentation());
        p.printKeyword("WHERE");
        this.printNestedElementList(p, SP.where);
    }
}

