/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.spr.spra;

import java.util.HashMap;
import java.util.List;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.spr.AbstractTableEngine;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.vocabulary.SPRA;

public class ATableEngine
extends AbstractTableEngine {
    @Override
    public Resource createTable(Model model, ResultSet rs) {
        String ns = "http://spinrdf.org/spra#";
        String id = AnonId.create().getLabelString().replaceAll(":", "_");
        Resource table = model.getResource("http://atables.org/data" + id);
        List<String> varNames = rs.getResultVars();
        this.addVarNames(ns, table, varNames);
        Property valueProperty = this.getValueProperty(ns);
        HashMap<Resource, RDFNode> cell2Value = new HashMap<Resource, RDFNode>();
        int row = 0;
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            for (int col = 0; col < varNames.size(); ++col) {
                String varName = varNames.get(col);
                RDFNode value = qs.get(varName);
                if (value == null) continue;
                Resource cell = this.getCell(table, row, col);
                cell2Value.put(cell, value);
            }
            ++row;
        }
        table.addProperty(RDF.type, SPRA.Table);
        for (Resource cell : cell2Value.keySet()) {
            RDFNode value = (RDFNode)cell2Value.get(cell);
            cell.addProperty(valueProperty, value);
        }
        table.addProperty(this.getColCountProperty(ns), JenaDatatypes.createInteger(varNames.size()));
        table.addProperty(this.getRowCountProperty(ns), JenaDatatypes.createInteger(row));
        return table;
    }

    private Resource getCell(Resource table, int row, int col) {
        return table.getModel().getResource(table.getURI() + "-r" + row + "-c" + col);
    }
}

