/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.core.DatasetGraphBase;
import org.apache.jena.sparql.core.Quad;

public class DatasetWrappingDatasetGraph
extends DatasetGraphBase {
    private Dataset dataset;

    public DatasetWrappingDatasetGraph(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public void add(Quad quad) {
        Graph graph = this.getGraph(quad);
        if (graph != null) {
            graph.add(quad.asTriple());
        }
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.dataset.containsNamedModel(graphNode.getURI());
    }

    @Override
    public void delete(Quad quad) {
        Graph graph = this.getGraph(quad);
        if (graph != null) {
            graph.delete(quad.asTriple());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        LinkedList<Node> results = new LinkedList<Node>();
        Iterator<String> names = this.dataset.listNames();
        while (names.hasNext()) {
            String name = names.next();
            results.add(NodeFactory.createURI(name));
        }
        return results.iterator();
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Graph getDefaultGraph() {
        Model defaultModel = this.dataset.getDefaultModel();
        if (defaultModel != null) {
            return defaultModel.getGraph();
        }
        return null;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        try {
            Model model = this.dataset.getNamedModel(graphNode.getURI());
            if (model != null) {
                return model.getGraph();
            }
            return null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception accessing named graph " + graphNode, ex);
        }
    }

    protected Graph getGraph(Quad quad) {
        if (quad.isDefaultGraph()) {
            return this.getDefaultGraph();
        }
        return this.getGraph(quad.getGraph());
    }

    @Override
    public Lock getLock() {
        return this.dataset.getLock();
    }

    @Override
    public long size() {
        int count = 0;
        Iterator<Node> it = this.listGraphNodes();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeGraph(Node graphName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.dataset.begin(readWrite);
    }

    @Override
    public void commit() {
        this.dataset.commit();
    }

    @Override
    public void abort() {
        this.dataset.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.dataset.isInTransaction();
    }

    @Override
    public void end() {
        this.dataset.end();
    }

    @Override
    public boolean supportsTransactions() {
        return this.dataset.supportsTransactions();
    }
}

