/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    public static RuntimeException throwRootCauseUnchecked(Throwable t) {
        return ExceptionUtil.throwDeepCauseChecked(t, RuntimeException.class);
    }

    public static RuntimeException throwUnchecked(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static <EX extends Throwable> EX throwDeepCauseChecked(Throwable t, Class<? extends EX> clazz) throws EX {
        if (t == null) {
            throw new NullPointerException();
        }
        Error firstError = null;
        Object firstEX = null;
        RuntimeException firstRTE = null;
        for (Throwable tt = t; tt != null; tt = tt.getCause()) {
            firstError = ExceptionUtil.chooseNonNullCorrectClass(Error.class, firstError, tt);
            firstEX = ExceptionUtil.chooseNonNullCorrectClass(clazz, firstEX, tt);
            firstRTE = ExceptionUtil.chooseNonNullCorrectClass(RuntimeException.class, firstRTE, tt);
        }
        if (firstError != null) {
            throw firstError;
        }
        if (firstEX != null) {
            throw firstEX;
        }
        if (firstRTE != null) {
            throw firstRTE;
        }
        Throwable rslt = null;
        try {
            rslt = (Throwable)clazz.getConstructor(Throwable.class).newInstance(t);
        }
        catch (Exception e2) {
            try {
                rslt = (Throwable)clazz.newInstance();
                rslt.initCause(t);
            }
            catch (Exception e1) {
                if (e1.getCause() == null) {
                    e1.initCause(t);
                }
                throw new IllegalArgumentException(clazz.getName() + " does not have a functioning constructor, with either no arguments or a Throwable argument.", e1);
            }
        }
        throw rslt;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    private static <TT extends Throwable> TT chooseNonNullCorrectClass(Class<? extends TT> clazz, TT firstError, Throwable tt) {
        if (firstError != null) {
            return firstError;
        }
        if (clazz.isInstance(tt)) {
            return (TT)tt;
        }
        return null;
    }

    public static <EX extends Throwable> EX getDeepCause(Throwable t, Class<? extends EX> clazz) {
        if (t == null) {
            throw new NullPointerException();
        }
        for (Throwable tt = t; tt != null; tt = tt.getCause()) {
            if (!clazz.isInstance(tt)) continue;
            return (EX)tt;
        }
        return null;
    }
}

