/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.model.CommandWithWhere;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.QueryOrTemplateCall;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Template;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.print.Printable;
import org.topbraid.spin.model.print.StringPrintContext;
import org.topbraid.spin.system.SPINModuleRegistry;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINUtil {
    public static final String TYPE_CLASS_VAR_NAME = "TYPE_CLASS";

    public static void addQueryOrTemplateCalls(Resource cls, Property predicate, List<QueryOrTemplateCall> results) {
        Template template;
        List ss = JenaUtil.listAllProperties(cls, predicate).toList();
        if (ss.isEmpty() && cls != null && cls.isURIResource() && (template = SPINModuleRegistry.get().getTemplate(cls.getURI(), null)) != null) {
            ss = JenaUtil.listAllProperties(template, predicate).toList();
        }
        for (Statement s : ss) {
            if (!s.getObject().isResource()) continue;
            TemplateCall templateCall = SPINFactory.asTemplateCall(s.getResource());
            if (templateCall != null) {
                results.add(new QueryOrTemplateCall(cls, templateCall));
                continue;
            }
            Query query = SPINFactory.asQuery(s.getResource());
            if (query == null) continue;
            results.add(new QueryOrTemplateCall(cls, query));
        }
    }

    public static String addThisTypeClause(String str2) {
        String varName = TYPE_CLASS_VAR_NAME;
        Pattern pattern = Pattern.compile("(?i)WHERE\\s*\\{");
        Matcher matcher = pattern.matcher(str2);
        if (matcher.find()) {
            int index = matcher.end();
            StringBuilder sb = new StringBuilder(str2);
            sb.insert(index, " ?this a ?" + varName + " . ");
            return sb.toString();
        }
        throw new IllegalArgumentException("Malformed query: could not find start of WHERE clause");
    }

    public static void applyBindings(Map<Property, RDFNode> map, Map<String, RDFNode> bindings) {
        for (Property property : new ArrayList<Property>(map.keySet())) {
            String varName;
            RDFNode b;
            RDFNode value = map.get(property);
            Variable var = SPINFactory.asVariable(value);
            if (var == null || (b = bindings.get(varName = var.getName())) == null) continue;
            map.put(property, b);
        }
    }

    public static void bindThis(QueryExecution qexec, RDFNode value) {
        if (value != null) {
            QuerySolutionMap bindings = new QuerySolutionMap();
            bindings.add("this", value);
            qexec.setInitialBinding(bindings);
        }
    }

    public static boolean containsThis(CommandWithWhere command) {
        String queryString = ARQFactory.get().createCommandString(command);
        return queryString.contains("?this");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDFNode getFirstResult(QueryExecution qexec) {
        try {
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext()) {
                RDFNode result2;
                String varName = rs.getResultVars().get(0);
                RDFNode rDFNode = result2 = rs.next().get(varName);
                return rDFNode;
            }
            RDFNode rDFNode = null;
            return rDFNode;
        }
        finally {
            qexec.close();
        }
    }

    public static String getQueryString(RDFNode node, boolean usePrefixes) {
        if (node.isLiteral()) {
            return ((Literal)node).getLexicalForm();
        }
        Resource resource = (Resource)node;
        Command spinCommand = SPINFactory.asCommand(resource);
        if (spinCommand != null) {
            if (usePrefixes) {
                StringPrintContext p = new StringPrintContext();
                p.setUsePrefixes(usePrefixes);
                spinCommand.print(p);
                return p.getString();
            }
            return ARQFactory.get().createCommandString(spinCommand);
        }
        TemplateCall templateCall = SPINFactory.asTemplateCall(resource);
        if (templateCall != null) {
            return templateCall.getQueryString();
        }
        throw new IllegalArgumentException("Node must be either literal or a SPIN query or a SPIN template call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getQueryStrings(Resource subject, Property property) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            Map<Statement, String> map = SPINUtil.getQueryStringMap(subject, property);
            Collection<String> collection = map.values();
            return collection;
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    public static Map<Statement, String> getQueryStringMap(Resource subject, Property property) {
        if (subject != null) {
            property = subject.getModel().getProperty(property.getURI());
        }
        HashMap<Statement, String> queryStrings = new HashMap<Statement, String>();
        Set<Resource> ps = JenaUtil.getAllSubProperties(property);
        ps.add(property);
        for (Resource p : ps) {
            StmtIterator it = property.getModel().listStatements(subject, JenaUtil.asProperty(p), (RDFNode)null);
            while (it.hasNext()) {
                Statement s = it.nextStatement();
                RDFNode object = s.getObject();
                String str2 = SPINUtil.getQueryString(object, false);
                queryStrings.put(s, str2);
            }
        }
        return queryStrings;
    }

    public static Set<Resource> getURIResources(Printable query) {
        final HashSet<Resource> results = new HashSet<Resource>();
        StringPrintContext context = new StringPrintContext(){

            @Override
            public PrintContext clone() {
                return this;
            }

            @Override
            public void printURIResource(Resource resource) {
                super.printURIResource(resource);
                results.add(resource);
            }
        };
        query.print(context);
        return results;
    }

    public static boolean isLibraryOntology(Graph graph, URI baseURI) {
        if (baseURI != null) {
            if ("http://spinrdf.org/sp".equals(baseURI.toString()) || "http://spinrdf.org/spin".equals(baseURI.toString())) {
                return true;
            }
            Node ontology = NodeFactory.createURI(baseURI.toString());
            return graph.contains(ontology, RDF.type.asNode(), SPIN.LibraryOntology.asNode());
        }
        return false;
    }

    public static boolean isRootClass(Resource cls) {
        return RDFS.Resource.equals(cls) || OWL.Thing.equals(cls);
    }

    public static Map<String, RDFNode> mapProperty2VarNames(Map<Property, RDFNode> map) {
        HashMap<String, RDFNode> results = new HashMap<String, RDFNode>();
        for (Property predicate : map.keySet()) {
            RDFNode value = map.get(predicate);
            results.put(predicate.getLocalName(), value);
        }
        return results;
    }
}

