/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;

public class SystemTriples {
    private static Model vocabulary;

    private static void ensureSuperClasses(Resource metaClass, Resource superClass) {
        List<Resource> toAdd = SystemTriples.collectMissingSuperClasses(metaClass, superClass);
        for (Resource c : toAdd) {
            vocabulary.add(c, RDFS.subClassOf, superClass);
        }
    }

    private static List<Resource> collectMissingSuperClasses(Resource metaClass, Resource superClass) {
        ArrayList<Resource> toAdd = new ArrayList<Resource>();
        StmtIterator it = vocabulary.listStatements(null, RDF.type, metaClass);
        while (it.hasNext()) {
            Resource c = it.nextStatement().getSubject();
            if (c.equals(superClass) || c.getProperty(RDFS.subClassOf) != null) continue;
            toAdd.add(c);
        }
        return toAdd;
    }

    public static synchronized Model getVocabularyModel() {
        if (vocabulary == null) {
            vocabulary = JenaUtil.createDefaultModel();
            JenaUtil.initNamespaces(vocabulary.getGraph());
            vocabulary.setNsPrefix("xsd", XSD.getURI());
            InputStream rdfs = SP.class.getResourceAsStream("/etc/rdf-schema.rdf");
            vocabulary.read(rdfs, RDFS.getURI());
            InputStream owl = SP.class.getResourceAsStream("/etc/owl.rdf");
            vocabulary.read(owl, OWL.getURI());
            vocabulary.removeNsPrefix("");
            SystemTriples.ensureSuperClasses(RDFS.Class, RDFS.Resource);
            SystemTriples.ensureSuperClasses(OWL.Class, OWL.Thing);
            vocabulary.removeAll(null, OWL.imports, null);
            vocabulary.add(OWL.Thing, RDFS.subClassOf, RDFS.Resource);
            vocabulary.add((Resource)OWL.inverseOf, RDF.type, OWL.SymmetricProperty);
            vocabulary.add((Resource)OWL.equivalentClass, RDF.type, OWL.SymmetricProperty);
            vocabulary.add((Resource)OWL.equivalentProperty, RDF.type, OWL.SymmetricProperty);
            vocabulary.add((Resource)OWL.equivalentProperty, RDFS.range, RDF.Property);
            vocabulary.add((Resource)OWL.differentFrom, RDF.type, OWL.SymmetricProperty);
            vocabulary.add((Resource)OWL.sameAs, RDF.type, OWL.SymmetricProperty);
            vocabulary.add((Resource)OWL.disjointWith, RDF.type, OWL.SymmetricProperty);
            Resource xml = vocabulary.getResource(XMLLiteralType.theXMLLiteralType.getURI());
            vocabulary.add(xml, RDFS.subClassOf, RDFS.Resource);
            for (String uri : JenaDatatypes.getDatatypeURIs()) {
                Resource r = vocabulary.getResource(uri);
                if (r.getProperty(RDF.type) != null) continue;
                vocabulary.add(r, RDF.type, RDFS.Datatype);
                vocabulary.add(r, RDFS.subClassOf, RDFS.Literal);
            }
            vocabulary.add(RDF.HTML, RDFS.label, "HTML");
            vocabulary.add((Resource)RDFS.comment, RDF.type, OWL.AnnotationProperty);
            vocabulary.add((Resource)RDFS.label, RDF.type, OWL.AnnotationProperty);
            vocabulary.add((Resource)RDFS.isDefinedBy, RDF.type, OWL.AnnotationProperty);
            vocabulary.add((Resource)RDFS.seeAlso, RDF.type, OWL.AnnotationProperty);
            for (Resource datatype : vocabulary.listSubjectsWithProperty(RDF.type, RDFS.Datatype).toList()) {
                datatype.addProperty(RDFS.label, datatype.getLocalName());
            }
            vocabulary = JenaUtil.asReadOnlyModel(vocabulary);
        }
        return vocabulary;
    }
}

