/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.topbraid.spin.util.ExceptionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class XMLOutput {
    private static final String DEFAULT_METHOD = "xml";
    private static final String DEFAULT_INDENT = "2";
    public static boolean USE_SAXON = false;
    private static final TransformerFactory xformFactory;

    public static TransformerFactory getTransformerFactory() {
        return xformFactory;
    }

    public static void printNode(Node node, OutputStream out) throws IOException {
        XMLOutput.printNode(node, new StreamResult(out));
        out.write(10);
        out.flush();
    }

    public static String toString(Node node) throws IOException {
        return XMLOutput.toString(node, DEFAULT_INDENT, DEFAULT_METHOD);
    }

    public static String toString(Node node, String indent, String method) throws IOException {
        StringWriter rslt = new StringWriter();
        XMLOutput.printNode(node, new StreamResult(rslt), indent, method);
        return rslt.toString();
    }

    public static void printNode(Node node, Writer pw) throws IOException {
        XMLOutput.printNode(node, new StreamResult(pw));
        pw.write(10);
        pw.flush();
    }

    private static void printNode(Node node, StreamResult streamResult) throws IOException {
        XMLOutput.printNode(node, streamResult, DEFAULT_INDENT, DEFAULT_METHOD);
    }

    private static void printNode(Node node, StreamResult streamResult, String indent, String method) throws IOException {
        Transformer xform = null;
        try {
            DocumentType docType;
            xform = xformFactory.newTransformer();
            xform.setOutputProperty("indent", "yes");
            xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", indent);
            xform.setOutputProperty("omit-xml-declaration", "yes");
            xform.setOutputProperty("encoding", "utf-8");
            xform.setOutputProperty("method", method);
            if (node instanceof Document && (docType = ((Document)node).getDoctype()) != null) {
                String publicId = docType.getPublicId();
                String systemId = docType.getSystemId();
                if (publicId != null && systemId != null) {
                    xform.setOutputProperty("doctype-public", publicId);
                    xform.setOutputProperty("doctype-system", systemId);
                }
            }
        }
        catch (TransformerConfigurationException e2) {
            throw ExceptionUtil.throwRootCauseUnchecked(e2);
        }
        try {
            xform.transform(new DOMSource(node), streamResult);
        }
        catch (TransformerException e3) {
            throw ExceptionUtil.throwDeepCauseChecked(e3, IOException.class);
        }
    }

    public static byte[] toByteArray(Node node) throws IOException {
        ByteArrayOutputStream rslt = new ByteArrayOutputStream();
        XMLOutput.printNode(node, new StreamResult(rslt));
        return rslt.toByteArray();
    }

    static {
        TransformerFactory xf = null;
        if (USE_SAXON) {
            try {
                xf = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
                System.err.println("Using saxon");
            }
            catch (TransformerFactoryConfigurationError e2) {
                System.err.println("Failed to load Saxon, using Xalan: " + e2.getMessage());
            }
        }
        if (xf == null) {
            xf = TransformerFactory.newInstance();
        }
        xformFactory = xf;
    }
}

