/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.render;

import java.io.Serializable;
import org.mulesoft.common.core.package$;
import org.mulesoft.common.core.package$Strings$;
import org.yaml.model.YDocument;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import org.yaml.model.YNode;
import org.yaml.model.YScalar;
import org.yaml.model.YSequence;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import org.yaml.model.YValue;
import org.yaml.render.JsonRender$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001%\u0011!BS:p]J+g\u000eZ3s\u0015\t\u0019A!\u0001\u0004sK:$WM\u001d\u0006\u0003\u000b\u0019\tA!_1nY*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\nI\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000fY\u0001!\u0019!C\u0005/\u00059!-^5mI\u0016\u0014X#\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0003;1\t!bY8mY\u0016\u001cG/[8o\u0013\ty\"DA\u0007TiJLgn\u001a\"vS2$WM\u001d\u0005\u0007C\u0001\u0001\u000b\u0011\u0002\r\u0002\u0011\t,\u0018\u000e\u001c3fe\u0002BQa\t\u0001\u0005B\u0011\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002KA\u0011a%\f\b\u0003O-\u0002\"\u0001\u000b\u0007\u000e\u0003%R!A\u000b\u0005\u0002\rq\u0012xn\u001c;?\u0013\taC\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017\r\u0011\u001d\t\u0004\u00011A\u0005\nI\n1\"\u001b8eK:$\u0018\r^5p]V\t1\u0007\u0005\u0002\fi%\u0011Q\u0007\u0004\u0002\u0004\u0013:$\bbB\u001c\u0001\u0001\u0004%I\u0001O\u0001\u0010S:$WM\u001c;bi&|gn\u0018\u0013fcR\u0011\u0011\b\u0010\t\u0003\u0017iJ!a\u000f\u0007\u0003\tUs\u0017\u000e\u001e\u0005\b{Y\n\t\u00111\u00014\u0003\rAH%\r\u0005\u0007\u007f\u0001\u0001\u000b\u0015B\u001a\u0002\u0019%tG-\u001a8uCRLwN\u001c\u0011\t\u000b\u0005\u0003A\u0011\u0002\"\u0002\r%tG-\u001a8u)\u0005I\u0004\"\u0002#\u0001\t\u0013\u0011\u0015A\u00023fI\u0016tG\u000fC\u0003G\u0001\u0011%!#\u0001\u0007sK:$WM]%oI\u0016tG\u000fC\u0003\u0004\u0001\u0011%\u0001\n\u0006\u0002\u0014\u0013\")!j\u0012a\u0001\u0017\u0006!an\u001c3f!\tau*D\u0001N\u0015\tqE!A\u0003n_\u0012,G.\u0003\u0002Q\u001b\n)\u0011LT8eK\")!\u000b\u0001C\u0005'\u0006I!/\u001a8eKJ\u001cV-\u001d\u000b\u0003'QCQ!V)A\u0002Y\u000b1a]3r!\tau+\u0003\u0002Y\u001b\nI\u0011lU3rk\u0016t7-\u001a\u0005\u00065\u0002!IaW\u0001\u000eG\"|\u0007\u000fT1ti\u000e{W.\\1\u0015\u0003aAQ!\u0018\u0001\u0005\ny\u000b\u0011B]3oI\u0016\u0014X*\u00199\u0015\u0005My\u0006\"\u00021]\u0001\u0004\t\u0017aA7baB\u0011AJY\u0005\u0003G6\u0013A!W'ba\")Q\r\u0001C\u0005M\u0006a!/\u001a8eKJ\u001c6-\u00197beR\u0019\u0011h\u001a7\t\u000b!$\u0007\u0019A5\u0002\u0003Q\u0004\"\u0001\u00146\n\u0005-l%!B-UsB,\u0007\"B7e\u0001\u0004q\u0017AB:dC2\f'\u000f\u0005\u0002M_&\u0011\u0001/\u0014\u0002\b3N\u001b\u0017\r\\1s\u0011\u0015\u0019\u0001\u0001\"\u0003s)\t\u00192\u000fC\u0003uc\u0002\u0007Q%A\u0003wC2,XmB\u0003w\u0005!\u0005q/\u0001\u0006Kg>t'+\u001a8eKJ\u0004\"\u0001\u0006=\u0007\u000b\u0005\u0011\u0001\u0012A=\u0014\u0005aT\u0001\"B\ty\t\u0003YH#A<\t\u000b\rAH\u0011A?\u0015\u0005\u0015r\bBB@}\u0001\u0004\t\t!A\u0002e_\u000e\u00042\u0001TA\u0002\u0013\r\t)!\u0014\u0002\n3\u0012{7-^7f]R\u0004")
public class JsonRender {
    private final StringBuilder builder = new StringBuilder();
    private int indentation = 0;

    public static String render(YDocument yDocument) {
        return JsonRender$.MODULE$.render(yDocument);
    }

    private StringBuilder builder() {
        return this.builder;
    }

    public String toString() {
        return this.builder().toString();
    }

    private int indentation() {
        return this.indentation;
    }

    private void indentation_$eq(int x$1) {
        this.indentation = x$1;
    }

    private void indent() {
        this.indentation_$eq(this.indentation() + 2);
    }

    private void dedent() {
        this.indentation_$eq(this.indentation() - 2);
    }

    private JsonRender renderIndent() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.indentation()).foreach((Function1<Object, StringBuilder> & Serializable & scala.Serializable)_ -> JsonRender.$anonfun$renderIndent$1(this, BoxesRunTime.unboxToInt(_)));
        return this;
    }

    public JsonRender org$yaml$render$JsonRender$$render(YNode node) {
        Object object;
        YValue yValue = node.value();
        if (yValue instanceof YMap) {
            YMap yMap = (YMap)yValue;
            object = this.renderMap(yMap);
        } else if (yValue instanceof YSequence) {
            YSequence ySequence = (YSequence)yValue;
            object = this.renderSeq(ySequence);
        } else if (yValue instanceof YScalar) {
            YScalar yScalar = (YScalar)yValue;
            this.renderScalar(node.tagType(), yScalar);
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(yValue);
        }
        return this;
    }

    private JsonRender renderSeq(YSequence seq2) {
        JsonRender jsonRender;
        if (seq2.isEmpty()) {
            jsonRender = this.org$yaml$render$JsonRender$$render("[]");
        } else {
            this.org$yaml$render$JsonRender$$render("[\n");
            this.indent();
            seq2.nodes().foreach((Function1<YNode, JsonRender> & Serializable & scala.Serializable)x$1 -> this.renderIndent().org$yaml$render$JsonRender$$render((YNode)x$1).org$yaml$render$JsonRender$$render(",\n"));
            this.chopLastComma();
            this.dedent();
            jsonRender = this.renderIndent().org$yaml$render$JsonRender$$render("]");
        }
        return jsonRender;
    }

    private StringBuilder chopLastComma() {
        return this.builder().deleteCharAt(this.builder().length() - 2);
    }

    private JsonRender renderMap(YMap map) {
        JsonRender jsonRender;
        if (map.isEmpty()) {
            jsonRender = this.org$yaml$render$JsonRender$$render("{}");
        } else {
            this.org$yaml$render$JsonRender$$render("{\n");
            this.indent();
            map.entries().foreach((Function1<YMapEntry, JsonRender> & Serializable & scala.Serializable)e2 -> this.renderIndent().org$yaml$render$JsonRender$$render(e2.key()).org$yaml$render$JsonRender$$render(": ").org$yaml$render$JsonRender$$render(e2.value()).org$yaml$render$JsonRender$$render(",\n"));
            this.chopLastComma();
            this.dedent();
            jsonRender = this.renderIndent().org$yaml$render$JsonRender$$render("}");
        }
        return jsonRender;
    }

    private void renderScalar(YType t, YScalar scalar) {
        String string;
        boolean bl;
        YType yType = t;
        YType yType2 = YType$.MODULE$.Int();
        YType yType3 = yType;
        if (!(yType2 != null ? !yType2.equals(yType3) : yType3 != null)) {
            bl = true;
        } else {
            YType yType4 = YType$.MODULE$.Bool();
            YType yType5 = yType;
            bl = !(yType4 != null ? !yType4.equals(yType5) : yType5 != null);
        }
        if (bl) {
            string = scalar.value().toString();
        } else {
            YType yType6 = YType$.MODULE$.Float();
            YType yType7 = yType;
            if (!(yType6 != null ? !yType6.equals(yType7) : yType7 != null)) {
                String s = scalar.value().toString();
                string = s.indexOf(46) == -1 ? s + ".0" : s;
            } else {
                YType yType8 = YType$.MODULE$.Null();
                YType yType9 = yType;
                string = !(yType8 != null ? !yType8.equals(yType9) : yType9 != null) ? "null" : '\"' + package$Strings$.MODULE$.encode$extension(package$.MODULE$.Strings(scalar.text())) + '\"';
            }
        }
        this.org$yaml$render$JsonRender$$render(string);
    }

    public JsonRender org$yaml$render$JsonRender$$render(String value) {
        this.builder().append(value);
        return this;
    }

    public static final /* synthetic */ StringBuilder $anonfun$renderIndent$1(JsonRender $this, int _) {
        return $this.builder().append(' ');
    }
}

