/*
 * Decompiled with CFR 0.152.
 */
package amf.facades;

import amf.Core$;
import amf.core.AMFSerializer;
import amf.core.emitter.RenderOptions;
import amf.core.model.document.BaseUnit;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.plugins.AMFDomainPlugin;
import amf.core.plugins.AMFSyntaxPlugin;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Amf$;
import amf.core.remote.Extension$;
import amf.core.remote.Oas$;
import amf.core.remote.Oas2$;
import amf.core.remote.Oas2Yaml$;
import amf.core.remote.Oas3$;
import amf.core.remote.Payload$;
import amf.core.remote.Platform;
import amf.core.remote.Raml$;
import amf.core.remote.Raml08$;
import amf.core.remote.Raml10$;
import amf.core.remote.RamlVocabulary$;
import amf.core.remote.Syntax;
import amf.core.remote.Vendor;
import amf.facades.AMFRenderer$;
import amf.plugins.document.graph.AMFGraphPlugin$;
import amf.plugins.document.vocabularies.VocabulariesPlugin$;
import amf.plugins.document.webapi.JsonSchemaPlugin$;
import amf.plugins.document.webapi.OAS20Plugin$;
import amf.plugins.document.webapi.OAS30Plugin$;
import amf.plugins.document.webapi.PayloadPlugin$;
import amf.plugins.document.webapi.RAML08Plugin$;
import amf.plugins.document.webapi.RAML10Plugin$;
import amf.plugins.domain.shapes.DataShapesDomainPlugin$;
import amf.plugins.domain.webapi.WebAPIDomainPlugin$;
import amf.plugins.syntax.SYamlSyntaxPlugin$;
import java.io.Serializable;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u000f\tY\u0011)\u0014$SK:$WM]3s\u0015\t\u0019A!A\u0004gC\u000e\fG-Z:\u000b\u0003\u0015\t1!Y7g\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011!y\u0001A!A!\u0002\u0013\u0001\u0012\u0001B;oSR\u0004\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u0011\u0011|7-^7f]RT!!\u0006\f\u0002\u000b5|G-\u001a7\u000b\u0005]!\u0011\u0001B2pe\u0016L!!\u0007\n\u0003\u0011\t\u000b7/Z+oSRD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0007m\u0016tGm\u001c:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0012A\u0002:f[>$X-\u0003\u0002\"=\t1a+\u001a8e_JD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0007gftG/\u0019=\u0011\u0005\u0015\ndB\u0001\u00140\u001d\t9cF\u0004\u0002)[9\u0011\u0011\u0006L\u0007\u0002U)\u00111FB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0006\u0003\n\u0005}1\u0012B\u0001\u0019\u001f\u0003\u0019\u0019\u0016P\u001c;bq&\u0011!g\r\u0002\u0007'ftG/\u0019=\u000b\u0005Ar\u0002\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000f=\u0004H/[8ogB\u0011qGO\u0007\u0002q)\u0011\u0011HF\u0001\bK6LG\u000f^3s\u0013\tY\u0004HA\u0007SK:$WM](qi&|gn\u001d\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}\n%i\u0011#\u0011\u0005\u0001\u0003Q\"\u0001\u0002\t\u000b=a\u0004\u0019\u0001\t\t\u000bma\u0004\u0019\u0001\u000f\t\u000b\rb\u0004\u0019\u0001\u0013\t\u000bUb\u0004\u0019\u0001\u001c\t\u000b\u0019\u0003A\u0011A$\u0002\u001dI,g\u000eZ3s)>\u001cFO]5oOV\t\u0001\nE\u0002J\u0019:k\u0011A\u0013\u0006\u0003\u0017*\t!bY8oGV\u0014(/\u001a8u\u0013\ti%J\u0001\u0004GkR,(/\u001a\t\u0003\u001fNs!\u0001U)\u0011\u0005%R\u0011B\u0001*\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IS\u0001\"B,\u0001\t\u0003A\u0016\u0001\u0004:f]\u0012,'\u000fV8GS2,GcA-^CB\u0019\u0011\n\u0014.\u0011\u0005%Y\u0016B\u0001/\u000b\u0005\u0011)f.\u001b;\t\u000b}1\u0006\u0019\u00010\u0011\u0005uy\u0016B\u00011\u001f\u0005!\u0001F.\u0019;g_Jl\u0007\"\u00022W\u0001\u0004q\u0015\u0001\u00029bi\"DQ\u0001\u001a\u0001\u0005\n\u0015\faA]3oI\u0016\u0014H#\u0001%\b\u000b\u001d\u0014\u0001\u0012\u00015\u0002\u0017\u0005keIU3oI\u0016\u0014XM\u001d\t\u0003\u0001&4Q!\u0001\u0002\t\u0002)\u001c\"!\u001b\u0005\t\u000buJG\u0011\u00017\u0015\u0003!DQA\\5\u0005\u0002=\fQ!\u00199qYf$Ra\u00109reNDQaD7A\u0002AAQaG7A\u0002qAQaI7A\u0002\u0011BQ!N7A\u0002Y\u0002")
public class AMFRenderer {
    private final BaseUnit unit;
    private final Vendor vendor;
    private final RenderOptions options;

    public static AMFRenderer apply(BaseUnit baseUnit, Vendor vendor, Syntax.Syntax syntax, RenderOptions renderOptions) {
        return AMFRenderer$.MODULE$.apply(baseUnit, vendor, syntax, renderOptions);
    }

    public Future<String> renderToString() {
        return this.render();
    }

    public Future<BoxedUnit> renderToFile(Platform remote, String path) {
        return this.render().flatMap((Function1 & Serializable & scala.Serializable)s -> remote.write(path, s), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<String> render() {
        String string;
        boolean bl;
        Vendor vendor = this.vendor;
        String string2 = RamlVocabulary$.MODULE$.equals(vendor) ? "RAML Vocabularies" : (Amf$.MODULE$.equals(vendor) ? "AMF Graph" : (Payload$.MODULE$.equals(vendor) ? "AMF Payload" : (Raml08$.MODULE$.equals(vendor) ? "RAML 0.8" : ((bl = Raml10$.MODULE$.equals(vendor) ? true : Raml$.MODULE$.equals(vendor)) ? "RAML 1.0" : (Oas3$.MODULE$.equals(vendor) ? "OAS 3.0.0" : (Oas2$.MODULE$.equals(vendor) ? "OAS 2.0" : (Oas2Yaml$.MODULE$.equals(vendor) ? "OAS 2.0" : (Oas$.MODULE$.equals(vendor) ? "OAS 2.0" : (Extension$.MODULE$.equals(vendor) ? "RAML Vocabularies" : "Unknown Vendor")))))))));
        String vendorString = string2;
        Vendor vendor2 = this.vendor;
        if (Amf$.MODULE$.equals(vendor2)) {
            string = "application/ld+json";
        } else if (Payload$.MODULE$.equals(vendor2)) {
            string = "application/amf+json";
        } else {
            boolean bl2 = Raml10$.MODULE$.equals(vendor2) ? true : (Raml08$.MODULE$.equals(vendor2) ? true : (Raml$.MODULE$.equals(vendor2) ? true : RamlVocabulary$.MODULE$.equals(vendor2)));
            if (bl2) {
                string = "application/yaml";
            } else {
                boolean bl3 = Oas$.MODULE$.equals(vendor2) ? true : (Oas2$.MODULE$.equals(vendor2) ? true : Oas3$.MODULE$.equals(vendor2));
                if (bl3) {
                    string = "application/json";
                } else {
                    boolean bl4 = Extension$.MODULE$.equals(vendor2) ? true : Oas2Yaml$.MODULE$.equals(vendor2);
                    string = bl4 ? "application/yaml" : "text/plain";
                }
            }
        }
        String mediaType = string;
        return new AMFSerializer(this.unit, mediaType, vendorString, this.options).renderToString();
    }

    public AMFRenderer(BaseUnit unit, Vendor vendor, Syntax.Syntax syntax, RenderOptions options) {
        this.unit = unit;
        this.vendor = vendor;
        this.options = options;
        Core$.MODULE$.init();
        AMFPluginsRegistry$.MODULE$.registerSyntaxPlugin((AMFSyntaxPlugin)SYamlSyntaxPlugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)RAML10Plugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)RAML08Plugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)OAS20Plugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)OAS30Plugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)PayloadPlugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)AMFGraphPlugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)JsonSchemaPlugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDocumentPlugin((AMFDocumentPlugin)VocabulariesPlugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDomainPlugin((AMFDomainPlugin)WebAPIDomainPlugin$.MODULE$);
        AMFPluginsRegistry$.MODULE$.registerDomainPlugin((AMFDomainPlugin)DataShapesDomainPlugin$.MODULE$);
    }
}

