/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.features.validation;

import amf.ProfileNames$;
import amf.core.client.GenerationOptions$;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.Document;
import amf.core.model.domain.DomainElement;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.plugins.AMFPlugin;
import amf.core.plugins.AMFValidationPlugin;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Context$;
import amf.core.remote.Platform;
import amf.core.services.RuntimeCompiler$;
import amf.core.services.RuntimeSerializer$;
import amf.core.services.RuntimeValidator;
import amf.core.services.RuntimeValidator$;
import amf.core.unsafe.PlatformSecrets;
import amf.core.validation.AMFValidationReport;
import amf.core.validation.EffectiveValidations;
import amf.core.validation.EffectiveValidations$;
import amf.core.validation.core.ValidationProfile;
import amf.core.validation.core.ValidationReport;
import amf.core.validation.core.ValidationSpecification;
import amf.plugins.document.graph.AMFGraphPlugin$;
import amf.plugins.document.vocabularies.RAMLVocabulariesPlugin$;
import amf.plugins.document.vocabularies.model.domain.DomainEntity;
import amf.plugins.features.validation.ParserSideValidationPlugin;
import amf.plugins.features.validation.PlatformValidator$;
import amf.plugins.features.validation.ValidationMutex$;
import amf.plugins.features.validation.emitters.JSLibraryEmitter;
import amf.plugins.features.validation.emitters.ValidationJSONLDEmitter;
import amf.plugins.features.validation.emitters.ValidationJSONLDEmitter$;
import amf.plugins.features.validation.model.ParsedValidationProfile$;
import amf.plugins.features.validation.model.ValidationDialectText$;
import amf.plugins.syntax.SYamlSyntaxPlugin$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AMFValidatorPlugin$
extends ParserSideValidationPlugin
implements PlatformSecrets {
    public static AMFValidatorPlugin$ MODULE$;
    private final String ID;
    private final String url;
    private Map<String, Function0<ValidationProfile>> customValidationProfiles;
    private Map<String, AMFDocumentPlugin> customValidationProfilesPlugins;
    private final Platform platform;

    static {
        new AMFValidatorPlugin$();
    }

    public Platform platform() {
        return this.platform;
    }

    public void amf$core$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public String ID() {
        return this.ID;
    }

    public Future<AMFPlugin> init() {
        RuntimeValidator$.MODULE$.register((RuntimeValidator)this);
        String url = "http://raml.org/dialects/profile.raml";
        return RAMLVocabulariesPlugin$.MODULE$.registerDialect(url, ValidationDialectText$.MODULE$.text()).map((Function1 & Serializable & scala.Serializable)x$1 -> this, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Seq<AMFPlugin> dependencies() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AMFPlugin[]{SYamlSyntaxPlugin$.MODULE$, RAMLVocabulariesPlugin$.MODULE$, AMFGraphPlugin$.MODULE$}));
    }

    public String url() {
        return this.url;
    }

    public Map<String, Function0<ValidationProfile>> profiles() {
        return ((MapLike)AMFPluginsRegistry$.MODULE$.documentPlugins().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)tuple2._2();
                if (domainPlugin instanceof AMFValidationPlugin) {
                    AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                    return acc.$plus$plus((GenTraversableOnce)((AMFValidationPlugin)aMFDocumentPlugin).domainValidationProfiles(this.platform()));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Map acc = (Map)tuple2._1();
            return acc;
        })).$plus$plus(this.customValidationProfiles());
    }

    public Map<String, AMFDocumentPlugin> profilesPlugins() {
        return ((MapLike)AMFPluginsRegistry$.MODULE$.documentPlugins().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)tuple2._2();
                if (domainPlugin instanceof AMFValidationPlugin) {
                    AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                    return acc.$plus$plus((GenTraversableOnce)((AMFValidationPlugin)aMFDocumentPlugin).domainValidationProfiles(this.platform()).keys().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                        Tuple2 tuple2 = new Tuple2(x0$3, x1$3);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Map accProfiles = (Map)tuple2._1();
                        String profileName = (String)tuple2._2();
                        Map map = accProfiles.updated((Object)profileName, (Object)aMFDocumentPlugin);
                        return map;
                    }));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Map acc = (Map)tuple2._1();
            return acc;
        })).$plus$plus(this.customValidationProfilesPlugins());
    }

    public Map<String, Function0<ValidationProfile>> customValidationProfiles() {
        return this.customValidationProfiles;
    }

    public void customValidationProfiles_$eq(Map<String, Function0<ValidationProfile>> x$1) {
        this.customValidationProfiles = x$1;
    }

    public Map<String, AMFDocumentPlugin> customValidationProfilesPlugins() {
        return this.customValidationProfilesPlugins;
    }

    public void customValidationProfilesPlugins_$eq(Map<String, AMFDocumentPlugin> x$1) {
        this.customValidationProfilesPlugins = x$1;
    }

    public Future<String> loadValidationProfile(String validationProfilePath) {
        return RuntimeCompiler$.MODULE$.apply(validationProfilePath, Option$.MODULE$.apply((Object)"application/yaml"), RAMLVocabulariesPlugin$.MODULE$.ID(), Context$.MODULE$.apply(this.platform()), RuntimeCompiler$.MODULE$.apply$default$5(), RuntimeCompiler$.MODULE$.apply$default$6(), RuntimeCompiler$.MODULE$.apply$default$7()).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            BaseUnit baseUnit = x0$4;
            if (!(baseUnit instanceof Document)) {
                throw new MatchError((Object)baseUnit);
            }
            Document document = (Document)baseUnit;
            DomainElement domainElement = document.encodes();
            return domainElement;
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            AMFDocumentPlugin aMFDocumentPlugin;
            DomainElement domainElement = x0$5;
            if (!(domainElement instanceof DomainEntity)) throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
            DomainEntity domainEntity = (DomainEntity)domainElement;
            String string = domainEntity.definition().shortName();
            String string2 = "Profile";
            if (string == null) {
                if (string2 != null) {
                    throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
                }
            } else if (!string.equals(string2)) throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
            ValidationProfile profile = ParsedValidationProfile$.MODULE$.apply(domainEntity);
            Option option = this.profilesPlugins().get((Object)profile.name());
            if (option instanceof Some) {
                AMFDocumentPlugin plugin;
                Some some = (Some)option;
                aMFDocumentPlugin = plugin = (AMFDocumentPlugin)some.value();
            } else {
                AMFDocumentPlugin plugin;
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                Option option2 = this.profilesPlugins().get(profile.baseProfileName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "AMF"));
                if (!(option2 instanceof Some)) {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plugin for custom validation profile ", ", ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{profile.name(), profile.baseProfileName()})));
                }
                Some some = (Some)option2;
                AMFDocumentPlugin aMFDocumentPlugin2 = plugin = (AMFDocumentPlugin)some.value();
                aMFDocumentPlugin = aMFDocumentPlugin2;
            }
            AMFDocumentPlugin domainPlugin = aMFDocumentPlugin;
            this.customValidationProfiles_$eq((Map<String, Function0<ValidationProfile>>)this.customValidationProfiles().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profile.name()), (Function0 & Serializable & scala.Serializable)() -> profile)));
            this.customValidationProfilesPlugins_$eq((Map<String, AMFDocumentPlugin>)this.customValidationProfilesPlugins().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profile.name()), (Object)domainPlugin)));
            return profile.name();
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public EffectiveValidations computeValidations(String profileName, EffectiveValidations computed) {
        EffectiveValidations effectiveValidations;
        None$ maybeProfile;
        None$ none$;
        Option option = this.profiles().get((Object)profileName);
        if (option instanceof Some) {
            Some some = (Some)option;
            Function0 profileGenerator = (Function0)some.value();
            none$ = new Some(profileGenerator.apply());
        } else {
            none$ = None$.MODULE$;
        }
        None$ none$2 = maybeProfile = none$;
        if (none$2 instanceof Some) {
            Some some = (Some)none$2;
            ValidationProfile foundProfile = (ValidationProfile)some.value();
            effectiveValidations = foundProfile.baseProfileName().isDefined() ? this.computeValidations((String)foundProfile.baseProfileName().get(), computed).someEffective(foundProfile) : computed.someEffective(foundProfile);
        } else if (None$.MODULE$.equals(none$2)) {
            effectiveValidations = computed;
        } else {
            throw new MatchError((Object)none$2);
        }
        return effectiveValidations;
    }

    public EffectiveValidations computeValidations$default$2() {
        return new EffectiveValidations(EffectiveValidations$.MODULE$.$lessinit$greater$default$1(), EffectiveValidations$.MODULE$.$lessinit$greater$default$2(), EffectiveValidations$.MODULE$.$lessinit$greater$default$3(), EffectiveValidations$.MODULE$.$lessinit$greater$default$4(), EffectiveValidations$.MODULE$.$lessinit$greater$default$5());
    }

    public Future<ValidationReport> shaclValidation(BaseUnit model, EffectiveValidations validations, String messageStyle) {
        Future<ValidationReport> future;
        String shapesJSON = this.shapesGraph(validations, messageStyle);
        Option<String> jsLibrary = new JSLibraryEmitter((Option<ValidationProfile>)None$.MODULE$).emitJS((Seq<ValidationSpecification>)validations.effective().values().toSeq());
        Option<String> option = jsLibrary;
        if (option instanceof Some) {
            Some some = (Some)option;
            String code = (String)some.value();
            PlatformValidator$.MODULE$.instance().registerLibrary(ValidationJSONLDEmitter$.MODULE$.validationLibraryUrl(), code);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        String modelJSON = RuntimeSerializer$.MODULE$.apply(model, "application/ld+json", "AMF Graph", GenerationOptions$.MODULE$.apply());
        ValidationMutex$ validationMutex$ = ValidationMutex$.MODULE$;
        synchronized (validationMutex$) {
            future = PlatformValidator$.MODULE$.instance().report(modelJSON, "application/ld+json", shapesJSON, "application/ld+json");
        }
        return future;
    }

    public Future<AMFValidationReport> validate(BaseUnit model, String profileName, String messageStyle) {
        return super.validate(model, profileName, messageStyle).flatMap((Function1 & Serializable & scala.Serializable)parserSideValidation -> {
            Future future;
            Some some;
            AMFDocumentPlugin domainPlugin;
            Option option = this.profilesPlugins().get((Object)profileName);
            if (option instanceof Some && (domainPlugin = (AMFDocumentPlugin)(some = (Some)option).value()) instanceof AMFValidationPlugin) {
                AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                EffectiveValidations validations = this.computeValidations(profileName, this.computeValidations$default$2());
                future = ((AMFValidationPlugin)aMFDocumentPlugin).validationRequest(model, profileName, validations, this.platform()).map((Function1 & Serializable & scala.Serializable)modelValidations -> {
                    boolean x$2 = modelValidations.conforms() && parserSideValidation.conforms();
                    Seq x$3 = (Seq)modelValidations.results().$plus$plus((GenTraversableOnce)parserSideValidation.results(), Seq$.MODULE$.canBuildFrom());
                    String x$4 = modelValidations.copy$default$2();
                    String x$5 = modelValidations.copy$default$3();
                    return modelValidations.copy(x$2, x$4, x$5, x$3);
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.profileNotFoundWarningReport(model, profileName), ExecutionContext.Implicits$.MODULE$.global());
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public AMFValidationReport profileNotFoundWarningReport(BaseUnit model, String profileName) {
        return new AMFValidationReport(true, model.location(), profileName, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public String shapesGraph(EffectiveValidations validations, String messageStyle) {
        return new ValidationJSONLDEmitter(messageStyle).emitJSON((Seq<ValidationSpecification>)((Seq)validations.effective().values().toSeq().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AMFValidatorPlugin$.$anonfun$shapesGraph$1(s)))));
    }

    public String shapesGraph$default$2() {
        return ProfileNames$.MODULE$.RAML();
    }

    public static final /* synthetic */ boolean $anonfun$shapesGraph$1(ValidationSpecification s) {
        return !s.isParserSide();
    }

    private AMFValidatorPlugin$() {
        MODULE$ = this;
        PlatformSecrets.$init$((PlatformSecrets)this);
        this.ID = "AMF Validation";
        this.url = "http://raml.org/dialects/profile.raml";
        this.customValidationProfiles = Predef$.MODULE$.Map().empty();
        this.customValidationProfilesPlugins = Predef$.MODULE$.Map().empty();
    }
}

