/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.vocabularies.core;

import amf.core.metamodel.Type;
import amf.core.model.domain.AmfArray;
import amf.core.model.domain.AmfElement;
import amf.core.model.domain.AmfScalar;
import amf.plugins.document.vocabularies.core.ErrorReporter;
import amf.plugins.document.vocabularies.core.ValidationIssue;
import amf.plugins.document.vocabularies.core.ValidationIssue$;
import amf.plugins.document.vocabularies.model.domain.DomainEntity;
import amf.plugins.document.vocabularies.spec.DialectPropertyMapping;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u00015\u0011\u0001\u0003R5bY\u0016\u001cGOV1mS\u0012\fGo\u001c:\u000b\u0005\r!\u0011\u0001B2pe\u0016T!!\u0002\u0004\u0002\u0019Y|7-\u00192vY\u0006\u0014\u0018.Z:\u000b\u0005\u001dA\u0011\u0001\u00033pGVlWM\u001c;\u000b\u0005%Q\u0011a\u00029mk\u001eLgn\u001d\u0006\u0002\u0017\u0005\u0019\u0011-\u001c4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!Q1A\u0005\u0002Y\t\u0001B]3q_J$XM]\u000b\u0002/A\u0011\u0001$G\u0007\u0002\u0005%\u0011!D\u0001\u0002\u000e\u000bJ\u0014xN\u001d*fa>\u0014H/\u001a:\t\u0011q\u0001!\u0011!Q\u0001\n]\t\u0011B]3q_J$XM\u001d\u0011\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\t\u0001\u0013\u0005\u0005\u0002\u0019\u0001!)Q#\ba\u0001/!)1\u0005\u0001C\u0001I\u0005Aa/\u00197jI\u0006$X\r\u0006\u0002&QA\u0011qBJ\u0005\u0003OA\u0011A!\u00168ji\")\u0011F\ta\u0001U\u0005\tQ\r\u0005\u0002,a5\tAF\u0003\u0002.]\u00051Am\\7bS:T!a\f\u0003\u0002\u000b5|G-\u001a7\n\u0005Eb#\u0001\u0004#p[\u0006Lg.\u00128uSRL\b\"B\u001a\u0001\t\u0013!\u0014!\u0004<bY&$\u0017\r^3WC2,X\r\u0006\u0003&kYr\u0004\"B\u00153\u0001\u0004Q\u0003\"B\u001c3\u0001\u0004A\u0014\u0001\u00029s_B\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0003\u0002\tM\u0004XmY\u0005\u0003{i\u0012a\u0003R5bY\u0016\u001cG\u000f\u0015:pa\u0016\u0014H/_'baBLgn\u001a\u0005\u0006\u007fI\u0002\r\u0001Q\u0001\u0006m\u0006dW/\u001a\t\u0003\u0003\u0016k\u0011A\u0011\u0006\u0003[\rS!a\f#\u000b\u0005\rQ\u0011B\u0001$C\u0005)\tUNZ#mK6,g\u000e\u001e\u0005\u0006\u0011\u0002!I!S\u0001\u000fm\u0006d\u0017\u000eZ1uKN\u001b\u0017\r\\1s)\u0011)#j\u0014)\t\u000b-;\u0005\u0019\u0001'\u0002\rM\u001c\u0017\r\\1s!\t\tU*\u0003\u0002O\u0005\nI\u0011)\u001c4TG\u0006d\u0017M\u001d\u0005\u0006S\u001d\u0003\rA\u000b\u0005\u0006o\u001d\u0003\r\u0001\u000f\u0005\u0006%\u0002!IaU\u0001\u000fm\u0006d\u0017\u000eZ1uK6Kg.T1y)\u0011)C+\u0016,\t\u000b-\u000b\u0006\u0019\u0001'\t\u000b%\n\u0006\u0019\u0001\u0016\t\u000b]\n\u0006\u0019\u0001\u001d\t\u000ba\u0003A\u0011B-\u0002\u0019Y\fG.\u001b3bi\u0016,e.^7\u0015\t\u0015R6\f\u0018\u0005\u0006\u0017^\u0003\r\u0001\u0014\u0005\u0006S]\u0003\rA\u000b\u0005\u0006o]\u0003\r\u0001\u000f\u0005\u0006=\u0002!IaX\u0001\u0010m\u0006d\u0017\u000eZ1uKB\u000bG\u000f^3s]R!Q\u0005Y1c\u0011\u0015YU\f1\u0001M\u0011\u0015IS\f1\u0001+\u0011\u00159T\f1\u00019\u0011\u0015!\u0007\u0001\"\u0003f\u0003A1\u0018\r\\5eCR,\u0007K]8q)f\u0004X\r\u0006\u0003&M\u001eD\u0007\"B&d\u0001\u0004a\u0005\"B\u0015d\u0001\u0004Q\u0003\"B\u001cd\u0001\u0004At!\u00026\u0003\u0011\u0003Y\u0017\u0001\u0005#jC2,7\r\u001e,bY&$\u0017\r^8s!\tABNB\u0003\u0002\u0005!\u0005Qn\u0005\u0002m\u001d!)a\u0004\u001cC\u0001_R\t1\u000eC\u0003rY\u0012%!/\u0001\u000bsKR\u0014\u0018.\u001a<f\t>l\u0017-\u001b8F]RLG/\u001f\u000b\u0003UMDQ\u0001\u001e9A\u0002U\fA!\u001e8jiB\u0011a\u000f_\u0007\u0002o*\u0011qaQ\u0005\u0003s^\u0014\u0001BQ1tKVs\u0017\u000e\u001e\u0005\u0006G1$\ta\u001f\u000b\u0004y\u0006]\u0001#B?\u0002\f\u0005Eab\u0001@\u0002\b9\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u0003\u0013\u0001\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyA\u0001\u0003MSN$(bAA\u0005!A\u0019\u0001$a\u0005\n\u0007\u0005U!AA\bWC2LG-\u0019;j_:L5o];f\u0011\u0015!(\u00101\u0001v\u0011\u0019\u0019C\u000e\"\u0001\u0002\u001cQ\u0019A0!\b\t\r%\nI\u00021\u0001+\u0001")
public class DialectValidator {
    private final ErrorReporter reporter;

    public ErrorReporter reporter() {
        return this.reporter;
    }

    public void validate(DomainEntity e) {
        e.definition().props().values().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            DialectValidator.$anonfun$validate$1(this, e, prop);
            return BoxedUnit.UNIT;
        });
    }

    private void validateValue(DomainEntity e, DialectPropertyMapping prop, AmfElement value) {
        AmfElement amfElement = value;
        if (amfElement instanceof AmfScalar) {
            AmfScalar amfScalar = (AmfScalar)amfElement;
            this.validateScalar(amfScalar, e, prop);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (amfElement instanceof DomainEntity) {
            DomainEntity domainEntity = (DomainEntity)amfElement;
            if (prop.isScalar() && !prop.allowInplace()) {
                this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should be scalar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop.name()})), e, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
            }
            this.validate(domainEntity);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)amfElement);
        }
    }

    private void validateScalar(AmfScalar scalar, DomainEntity e, DialectPropertyMapping prop) {
        this.validatePropType(scalar, e, prop);
        this.validatePattern(scalar, e, prop);
        this.validateEnum(scalar, e, prop);
        this.validateMinMax(scalar, e, prop);
    }

    private void validateMinMax(AmfScalar scalar, DomainEntity e, DialectPropertyMapping prop) {
        prop.minimum().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> {
            try {
                double d = new StringOps(Predef$.MODULE$.augmentString(scalar.toString())).toDouble();
                if (d < (double)m) {
                    this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should be not less then ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop.name(), BoxesRunTime.boxToInteger((int)m)})), e, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
                }
            }
            catch (Throwable throwable) {}
        });
        prop.maximum().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> {
            try {
                double d = new StringOps(Predef$.MODULE$.augmentString(scalar.toString())).toDouble();
                if (d > (double)m) {
                    this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should be not more then ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop.name(), BoxesRunTime.boxToInteger((int)m)})), e, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
                }
            }
            catch (Throwable throwable) {}
        });
    }

    private void validateEnum(AmfScalar scalar, DomainEntity e, DialectPropertyMapping prop) {
        prop.enum().foreach((Function1 & Serializable & scala.Serializable)ev -> {
            DialectValidator.$anonfun$validateEnum$1(this, scalar, e, prop, ev);
            return BoxedUnit.UNIT;
        });
    }

    private void validatePattern(AmfScalar scalar, DomainEntity e, DialectPropertyMapping prop) {
        prop.pattern().foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            DialectValidator.$anonfun$validatePattern$1(this, scalar, e, prop, pattern);
            return BoxedUnit.UNIT;
        });
    }

    private void validatePropType(AmfScalar scalar, DomainEntity e, DialectPropertyMapping prop) {
        block6: {
            if (!prop.isScalar()) {
                this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should be object"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop.name()})), e, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
            }
            Type type = prop.range();
            Type.Bool$ bool$ = Type.Bool$.MODULE$;
            if (!(type != null ? !type.equals(bool$) : bool$ != null)) {
                String string = scalar.toString();
                String string2 = "true";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = scalar.toString();
                    String string4 = "false";
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should be boolean"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop.name()})), e, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
                    }
                }
            }
            Type type2 = prop.range();
            Type.Int$ int$ = Type.Int$.MODULE$;
            if (type2 != null ? !type2.equals(int$) : int$ != null) break block6;
            try {
                new StringOps(Predef$.MODULE$.augmentString(scalar.toString())).toInt();
            }
            catch (Throwable throwable) {
                this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should be integer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop.name()})), e, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$validate$1(DialectValidator $this, DomainEntity e$1, DialectPropertyMapping prop) {
        block3: {
            boolean isDefined = e$1.fields().raw(prop.field()).isDefined();
            if (prop.required() && !isDefined) {
                $this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"missing required property:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop.name()})), e$1, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
            }
            if (!isDefined) break block3;
            AmfElement value = e$1.fields().get(prop.field());
            AmfElement amfElement = value;
            if (amfElement instanceof AmfArray) {
                AmfArray amfArray = (AmfArray)amfElement;
                amfArray.values().foreach((Function1 & Serializable & scala.Serializable)v -> {
                    $this.validateValue(e$1, prop, v);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.validateValue(e$1, prop, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$validateEnum$1(DialectValidator $this, AmfScalar scalar$2, DomainEntity e$3, DialectPropertyMapping prop$2, Seq ev) {
        block0: {
            if (ev.indexOf((Object)scalar$2.toString()) != -1) break block0;
            $this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should be one of  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop$2.name(), ev})), e$3, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
        }
    }

    public static final /* synthetic */ void $anonfun$validatePattern$1(DialectValidator $this, AmfScalar scalar$1, DomainEntity e$2, DialectPropertyMapping prop$1, String pattern) {
        block0: {
            if (scalar$1.toString().matches(pattern)) break block0;
            $this.reporter().accept(new ValidationIssue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property ", " should match to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop$1.name(), pattern})), e$2, ValidationIssue$.MODULE$.apply$default$3(), ValidationIssue$.MODULE$.apply$default$4()));
        }
    }

    public DialectValidator(ErrorReporter reporter) {
        this.reporter = reporter;
    }
}

